package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsolePluginServiceBuilder extends ConsolePluginServiceFluent<ConsolePluginServiceBuilder> implements VisitableBuilder<ConsolePluginService,ConsolePluginServiceBuilder>{
  public ConsolePluginServiceBuilder() {
    this(false);
  }
  public ConsolePluginServiceBuilder(Boolean validationEnabled) {
    this(new ConsolePluginService(), validationEnabled);
  }
  public ConsolePluginServiceBuilder(ConsolePluginServiceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsolePluginServiceBuilder(ConsolePluginServiceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConsolePluginService(), validationEnabled);
  }
  public ConsolePluginServiceBuilder(ConsolePluginServiceFluent<?> fluent,ConsolePluginService instance) {
    this(fluent, instance, false);
  }
  public ConsolePluginServiceBuilder(ConsolePluginServiceFluent<?> fluent,ConsolePluginService instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConsolePluginService());

    if (instance != null) {
      fluent.withBasePath(instance.getBasePath());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPort(instance.getPort());
      fluent.withBasePath(instance.getBasePath());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withPort(instance.getPort());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConsolePluginServiceBuilder(ConsolePluginService instance) {
    this(instance,false);
  }
  public ConsolePluginServiceBuilder(ConsolePluginService instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConsolePluginService());

    if (instance != null) {
      this.withBasePath(instance.getBasePath());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withPort(instance.getPort());
      this.withBasePath(instance.getBasePath());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withPort(instance.getPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConsolePluginServiceFluent<?> fluent;
  Boolean validationEnabled;
  public ConsolePluginService build() {
    ConsolePluginService buildable = new ConsolePluginService(fluent.getBasePath(),fluent.getName(),fluent.getNamespace(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}