package io.fabric8.openshift.api.model.console.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConsoleNotificationSpecFluent<A extends ConsoleNotificationSpecFluent<A>> extends BaseFluent<A>{
  public ConsoleNotificationSpecFluent() {
  }
  
  public ConsoleNotificationSpecFluent(ConsoleNotificationSpec instance) {
    this.copyInstance(instance);
  }
  private String backgroundColor;
  private String color;
  private LinkBuilder link;
  private String location;
  private String text;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConsoleNotificationSpec instance) {
    instance = (instance != null ? instance : new ConsoleNotificationSpec());
  
    if (instance != null) {
        this.withBackgroundColor(instance.getBackgroundColor());
        this.withColor(instance.getColor());
        this.withLink(instance.getLink());
        this.withLocation(instance.getLocation());
        this.withText(instance.getText());
        this.withBackgroundColor(instance.getBackgroundColor());
        this.withColor(instance.getColor());
        this.withLink(instance.getLink());
        this.withLocation(instance.getLocation());
        this.withText(instance.getText());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public String getBackgroundColor() {
    return this.backgroundColor;
  }
  
  public A withBackgroundColor(String backgroundColor) {
    this.backgroundColor=backgroundColor; return (A) this;
  }
  
  public boolean hasBackgroundColor() {
    return this.backgroundColor != null;
  }
  
  public String getColor() {
    return this.color;
  }
  
  public A withColor(String color) {
    this.color=color; return (A) this;
  }
  
  public boolean hasColor() {
    return this.color != null;
  }
  
  public Link buildLink() {
    return this.link!=null ?this.link.build():null;
  }
  
  public A withLink(Link link) {
    _visitables.get("link").remove(this.link);
    if (link!=null){ this.link= new LinkBuilder(link); _visitables.get("link").add(this.link);} else { this.link = null; _visitables.get("link").remove(this.link); } return (A) this;
  }
  
  public boolean hasLink() {
    return this.link != null;
  }
  
  public A withNewLink(String href,String text) {
    return (A)withLink(new Link(href, text));
  }
  
  public LinkNested<A> withNewLink() {
    return new LinkNested(null);
  }
  
  public LinkNested<A> withNewLinkLike(Link item) {
    return new LinkNested(item);
  }
  
  public LinkNested<A> editLink() {
    return withNewLinkLike(java.util.Optional.ofNullable(buildLink()).orElse(null));
  }
  
  public LinkNested<A> editOrNewLink() {
    return withNewLinkLike(java.util.Optional.ofNullable(buildLink()).orElse(new LinkBuilder().build()));
  }
  
  public LinkNested<A> editOrNewLinkLike(Link item) {
    return withNewLinkLike(java.util.Optional.ofNullable(buildLink()).orElse(item));
  }
  
  public String getLocation() {
    return this.location;
  }
  
  public A withLocation(String location) {
    this.location=location; return (A) this;
  }
  
  public boolean hasLocation() {
    return this.location != null;
  }
  
  public String getText() {
    return this.text;
  }
  
  public A withText(String text) {
    this.text=text; return (A) this;
  }
  
  public boolean hasText() {
    return this.text != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConsoleNotificationSpecFluent that = (ConsoleNotificationSpecFluent) o;
    if (!java.util.Objects.equals(backgroundColor, that.backgroundColor)) return false;
  
    if (!java.util.Objects.equals(color, that.color)) return false;
  
    if (!java.util.Objects.equals(link, that.link)) return false;
  
    if (!java.util.Objects.equals(location, that.location)) return false;
  
    if (!java.util.Objects.equals(text, that.text)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(backgroundColor,  color,  link,  location,  text,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (backgroundColor != null) { sb.append("backgroundColor:"); sb.append(backgroundColor + ","); }
    if (color != null) { sb.append("color:"); sb.append(color + ","); }
    if (link != null) { sb.append("link:"); sb.append(link + ","); }
    if (location != null) { sb.append("location:"); sb.append(location + ","); }
    if (text != null) { sb.append("text:"); sb.append(text + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class LinkNested<N> extends LinkFluent<LinkNested<N>> implements Nested<N>{
    LinkNested(Link item) {
      this.builder = new LinkBuilder(this, item);
    }
    LinkBuilder builder;
    
    public N and() {
      return (N) ConsoleNotificationSpecFluent.this.withLink(builder.build());
    }
    
    public N endLink() {
      return and();
    }
    
  
  }

}