package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConsoleYAMLSampleSpecBuilder extends ConsoleYAMLSampleSpecFluent<ConsoleYAMLSampleSpecBuilder> implements VisitableBuilder<ConsoleYAMLSampleSpec,ConsoleYAMLSampleSpecBuilder>{
  public ConsoleYAMLSampleSpecBuilder() {
    this(new ConsoleYAMLSampleSpec());
  }
  
  public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpecFluent<?> fluent) {
    this(fluent, new ConsoleYAMLSampleSpec());
  }
  
  public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpecFluent<?> fluent,ConsoleYAMLSampleSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConsoleYAMLSampleSpecBuilder(ConsoleYAMLSampleSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConsoleYAMLSampleSpecFluent<?> fluent;
  
  public ConsoleYAMLSampleSpec build() {
    ConsoleYAMLSampleSpec buildable = new ConsoleYAMLSampleSpec(fluent.getDescription(),fluent.getSnippet(),fluent.getTargetResource(),fluent.getTitle(),fluent.getYaml());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}