package io.fabric8.openshift.api.model.console.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConsolePluginSpecBuilder extends ConsolePluginSpecFluent<ConsolePluginSpecBuilder> implements VisitableBuilder<ConsolePluginSpec,ConsolePluginSpecBuilder>{
  public ConsolePluginSpecBuilder() {
    this(new ConsolePluginSpec());
  }
  
  public ConsolePluginSpecBuilder(ConsolePluginSpecFluent<?> fluent) {
    this(fluent, new ConsolePluginSpec());
  }
  
  public ConsolePluginSpecBuilder(ConsolePluginSpecFluent<?> fluent,ConsolePluginSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConsolePluginSpecBuilder(ConsolePluginSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConsolePluginSpecFluent<?> fluent;
  
  public ConsolePluginSpec build() {
    ConsolePluginSpec buildable = new ConsolePluginSpec(fluent.getDisplayName(),fluent.buildProxy(),fluent.buildService());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}