package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConsoleSampleSpecBuilder extends ConsoleSampleSpecFluent<ConsoleSampleSpecBuilder> implements VisitableBuilder<ConsoleSampleSpec,ConsoleSampleSpecBuilder>{
  public ConsoleSampleSpecBuilder() {
    this(new ConsoleSampleSpec());
  }
  
  public ConsoleSampleSpecBuilder(ConsoleSampleSpecFluent<?> fluent) {
    this(fluent, new ConsoleSampleSpec());
  }
  
  public ConsoleSampleSpecBuilder(ConsoleSampleSpecFluent<?> fluent,ConsoleSampleSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConsoleSampleSpecBuilder(ConsoleSampleSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConsoleSampleSpecFluent<?> fluent;
  
  public ConsoleSampleSpec build() {
    ConsoleSampleSpec buildable = new ConsoleSampleSpec(fluent.getAbstract(),fluent.getDescription(),fluent.getIcon(),fluent.getProvider(),fluent.buildSource(),fluent.getTags(),fluent.getTitle(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}