package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConsoleLinkSpecBuilder extends ConsoleLinkSpecFluent<ConsoleLinkSpecBuilder> implements VisitableBuilder<ConsoleLinkSpec,ConsoleLinkSpecBuilder>{
  public ConsoleLinkSpecBuilder() {
    this(new ConsoleLinkSpec());
  }
  
  public ConsoleLinkSpecBuilder(ConsoleLinkSpecFluent<?> fluent) {
    this(fluent, new ConsoleLinkSpec());
  }
  
  public ConsoleLinkSpecBuilder(ConsoleLinkSpecFluent<?> fluent,ConsoleLinkSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConsoleLinkSpecBuilder(ConsoleLinkSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConsoleLinkSpecFluent<?> fluent;
  
  public ConsoleLinkSpec build() {
    ConsoleLinkSpec buildable = new ConsoleLinkSpec(fluent.buildApplicationMenu(),fluent.getHref(),fluent.getLocation(),fluent.buildNamespaceDashboard(),fluent.getText());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}