package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConsolePluginBackendBuilder extends ConsolePluginBackendFluent<ConsolePluginBackendBuilder> implements VisitableBuilder<ConsolePluginBackend,ConsolePluginBackendBuilder>{
  public ConsolePluginBackendBuilder() {
    this(new ConsolePluginBackend());
  }
  
  public ConsolePluginBackendBuilder(ConsolePluginBackendFluent<?> fluent) {
    this(fluent, new ConsolePluginBackend());
  }
  
  public ConsolePluginBackendBuilder(ConsolePluginBackendFluent<?> fluent,ConsolePluginBackend instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConsolePluginBackendBuilder(ConsolePluginBackend instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConsolePluginBackendFluent<?> fluent;
  
  public ConsolePluginBackend build() {
    ConsolePluginBackend buildable = new ConsolePluginBackend(fluent.buildService(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}