package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AWSPrivateLinkConfigBuilder extends io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfigFluentImpl<io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfig,io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfigBuilder>{
  public AWSPrivateLinkConfigBuilder() {
    this(false);
  }
  public AWSPrivateLinkConfigBuilder(java.lang.Boolean validationEnabled) {
    this(new AWSPrivateLinkConfig(), validationEnabled);
  }
  public AWSPrivateLinkConfigBuilder(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSPrivateLinkConfigBuilder(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AWSPrivateLinkConfig(), validationEnabled);
  }
  public AWSPrivateLinkConfigBuilder(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfigFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfig instance) {
    this(fluent, instance, false);
  }
  public AWSPrivateLinkConfigBuilder(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfigFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAssociatedVPCs(instance.getAssociatedVPCs()); 
    fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    fluent.withDnsRecordType(instance.getDnsRecordType()); 
    fluent.withEndpointVPCInventory(instance.getEndpointVPCInventory()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AWSPrivateLinkConfigBuilder(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfig instance) {
    this(instance,false);
  }
  public AWSPrivateLinkConfigBuilder(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAssociatedVPCs(instance.getAssociatedVPCs()); 
    this.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    this.withDnsRecordType(instance.getDnsRecordType()); 
    this.withEndpointVPCInventory(instance.getEndpointVPCInventory()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfig build() {
    AWSPrivateLinkConfig buildable = new AWSPrivateLinkConfig(fluent.getAssociatedVPCs(),fluent.getCredentialsSecretRef(),fluent.getDnsRecordType(),fluent.getEndpointVPCInventory());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSPrivateLinkConfigBuilder that = (AWSPrivateLinkConfigBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}