package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class BackupConfigBuilder extends io.fabric8.openshift.api.model.hive.v1.BackupConfigFluentImpl<io.fabric8.openshift.api.model.hive.v1.BackupConfigBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.BackupConfig,io.fabric8.openshift.api.model.hive.v1.BackupConfigBuilder>{
  public BackupConfigBuilder() {
    this(false);
  }
  public BackupConfigBuilder(java.lang.Boolean validationEnabled) {
    this(new BackupConfig(), validationEnabled);
  }
  public BackupConfigBuilder(io.fabric8.openshift.api.model.hive.v1.BackupConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public BackupConfigBuilder(io.fabric8.openshift.api.model.hive.v1.BackupConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BackupConfig(), validationEnabled);
  }
  public BackupConfigBuilder(io.fabric8.openshift.api.model.hive.v1.BackupConfigFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.BackupConfig instance) {
    this(fluent, instance, false);
  }
  public BackupConfigBuilder(io.fabric8.openshift.api.model.hive.v1.BackupConfigFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.BackupConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds()); 
    fluent.withVelero(instance.getVelero()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BackupConfigBuilder(io.fabric8.openshift.api.model.hive.v1.BackupConfig instance) {
    this(instance,false);
  }
  public BackupConfigBuilder(io.fabric8.openshift.api.model.hive.v1.BackupConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds()); 
    this.withVelero(instance.getVelero()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.BackupConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.BackupConfig build() {
    BackupConfig buildable = new BackupConfig(fluent.getMinBackupPeriodSeconds(),fluent.getVelero());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BackupConfigBuilder that = (BackupConfigBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}