package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClusterClaimSpecBuilder extends io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpecFluentImpl<io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpec,io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpecBuilder>{
  public ClusterClaimSpecBuilder() {
    this(false);
  }
  public ClusterClaimSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ClusterClaimSpec(), validationEnabled);
  }
  public ClusterClaimSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterClaimSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterClaimSpec(), validationEnabled);
  }
  public ClusterClaimSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpecFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterClaimSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpecFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterPoolName(instance.getClusterPoolName()); 
    fluent.withLifetime(instance.getLifetime()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withSubjects(instance.getSubjects()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterClaimSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpec instance) {
    this(instance,false);
  }
  public ClusterClaimSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterPoolName(instance.getClusterPoolName()); 
    this.withLifetime(instance.getLifetime()); 
    this.withNamespace(instance.getNamespace()); 
    this.withSubjects(instance.getSubjects()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpec build() {
    ClusterClaimSpec buildable = new ClusterClaimSpec(fluent.getClusterPoolName(),fluent.getLifetime(),fluent.getNamespace(),fluent.getSubjects());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterClaimSpecBuilder that = (ClusterClaimSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}