package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClusterDeploymentSpecBuilder extends io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpecFluentImpl<io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpec,io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpecBuilder>{
  public ClusterDeploymentSpecBuilder() {
    this(false);
  }
  public ClusterDeploymentSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ClusterDeploymentSpec(), validationEnabled);
  }
  public ClusterDeploymentSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDeploymentSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterDeploymentSpec(), validationEnabled);
  }
  public ClusterDeploymentSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpecFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterDeploymentSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpecFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBaseDomain(instance.getBaseDomain()); 
    fluent.withBoundServiceAccountSigningKeySecretRef(instance.getBoundServiceAccountSigningKeySecretRef()); 
    fluent.withCertificateBundles(instance.getCertificateBundles()); 
    fluent.withClusterInstallRef(instance.getClusterInstallRef()); 
    fluent.withClusterMetadata(instance.getClusterMetadata()); 
    fluent.withClusterName(instance.getClusterName()); 
    fluent.withClusterPoolRef(instance.getClusterPoolRef()); 
    fluent.withControlPlaneConfig(instance.getControlPlaneConfig()); 
    fluent.withHibernateAfter(instance.getHibernateAfter()); 
    fluent.withIngress(instance.getIngress()); 
    fluent.withInstallAttemptsLimit(instance.getInstallAttemptsLimit()); 
    fluent.withInstalled(instance.getInstalled()); 
    fluent.withManageDNS(instance.getManageDNS()); 
    fluent.withPlatform(instance.getPlatform()); 
    fluent.withPowerState(instance.getPowerState()); 
    fluent.withPreserveOnDelete(instance.getPreserveOnDelete()); 
    fluent.withProvisioning(instance.getProvisioning()); 
    fluent.withPullSecretRef(instance.getPullSecretRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterDeploymentSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpec instance) {
    this(instance,false);
  }
  public ClusterDeploymentSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBaseDomain(instance.getBaseDomain()); 
    this.withBoundServiceAccountSigningKeySecretRef(instance.getBoundServiceAccountSigningKeySecretRef()); 
    this.withCertificateBundles(instance.getCertificateBundles()); 
    this.withClusterInstallRef(instance.getClusterInstallRef()); 
    this.withClusterMetadata(instance.getClusterMetadata()); 
    this.withClusterName(instance.getClusterName()); 
    this.withClusterPoolRef(instance.getClusterPoolRef()); 
    this.withControlPlaneConfig(instance.getControlPlaneConfig()); 
    this.withHibernateAfter(instance.getHibernateAfter()); 
    this.withIngress(instance.getIngress()); 
    this.withInstallAttemptsLimit(instance.getInstallAttemptsLimit()); 
    this.withInstalled(instance.getInstalled()); 
    this.withManageDNS(instance.getManageDNS()); 
    this.withPlatform(instance.getPlatform()); 
    this.withPowerState(instance.getPowerState()); 
    this.withPreserveOnDelete(instance.getPreserveOnDelete()); 
    this.withProvisioning(instance.getProvisioning()); 
    this.withPullSecretRef(instance.getPullSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.ClusterDeploymentSpec build() {
    ClusterDeploymentSpec buildable = new ClusterDeploymentSpec(fluent.getBaseDomain(),fluent.getBoundServiceAccountSigningKeySecretRef(),fluent.getCertificateBundles(),fluent.getClusterInstallRef(),fluent.getClusterMetadata(),fluent.getClusterName(),fluent.getClusterPoolRef(),fluent.getControlPlaneConfig(),fluent.getHibernateAfter(),fluent.getIngress(),fluent.getInstallAttemptsLimit(),fluent.getInstalled(),fluent.getManageDNS(),fluent.getPlatform(),fluent.getPowerState(),fluent.getPreserveOnDelete(),fluent.getProvisioning(),fluent.getPullSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterDeploymentSpecBuilder that = (ClusterDeploymentSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}