package io.fabric8.openshift.api.model.hive.vsphere.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PlatformBuilder extends io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformFluentImpl<io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.vsphere.v1.Platform,io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformBuilder>{
  public PlatformBuilder() {
    this(false);
  }
  public PlatformBuilder(java.lang.Boolean validationEnabled) {
    this(new Platform(), validationEnabled);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Platform(), validationEnabled);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformFluent<?> fluent,io.fabric8.openshift.api.model.hive.vsphere.v1.Platform instance) {
    this(fluent, instance, false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformFluent<?> fluent,io.fabric8.openshift.api.model.hive.vsphere.v1.Platform instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCertificatesSecretRef(instance.getCertificatesSecretRef()); 
    fluent.withCluster(instance.getCluster()); 
    fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    fluent.withDatacenter(instance.getDatacenter()); 
    fluent.withDefaultDatastore(instance.getDefaultDatastore()); 
    fluent.withFolder(instance.getFolder()); 
    fluent.withNetwork(instance.getNetwork()); 
    fluent.withVCenter(instance.getVCenter()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.hive.vsphere.v1.Platform instance) {
    this(instance,false);
  }
  public PlatformBuilder(io.fabric8.openshift.api.model.hive.vsphere.v1.Platform instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCertificatesSecretRef(instance.getCertificatesSecretRef()); 
    this.withCluster(instance.getCluster()); 
    this.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    this.withDatacenter(instance.getDatacenter()); 
    this.withDefaultDatastore(instance.getDefaultDatastore()); 
    this.withFolder(instance.getFolder()); 
    this.withNetwork(instance.getNetwork()); 
    this.withVCenter(instance.getVCenter()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.vsphere.v1.PlatformFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.vsphere.v1.Platform build() {
    Platform buildable = new Platform(fluent.getCertificatesSecretRef(),fluent.getCluster(),fluent.getCredentialsSecretRef(),fluent.getDatacenter(),fluent.getDefaultDatastore(),fluent.getFolder(),fluent.getNetwork(),fluent.getVCenter());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PlatformBuilder that = (PlatformBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}