package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class EC2RootVolumeBuilder extends io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolumeFluentImpl<io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolumeBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolume,io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolumeBuilder>{
  public EC2RootVolumeBuilder() {
    this(false);
  }
  public EC2RootVolumeBuilder(java.lang.Boolean validationEnabled) {
    this(new EC2RootVolume(), validationEnabled);
  }
  public EC2RootVolumeBuilder(io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public EC2RootVolumeBuilder(io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolumeFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EC2RootVolume(), validationEnabled);
  }
  public EC2RootVolumeBuilder(io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolumeFluent<?> fluent,io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolume instance) {
    this(fluent, instance, false);
  }
  public EC2RootVolumeBuilder(io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolumeFluent<?> fluent,io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolume instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIops(instance.getIops()); 
    fluent.withKmsKeyARN(instance.getKmsKeyARN()); 
    fluent.withSize(instance.getSize()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EC2RootVolumeBuilder(io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolume instance) {
    this(instance,false);
  }
  public EC2RootVolumeBuilder(io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolume instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withIops(instance.getIops()); 
    this.withKmsKeyARN(instance.getKmsKeyARN()); 
    this.withSize(instance.getSize()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolumeFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolume build() {
    EC2RootVolume buildable = new EC2RootVolume(fluent.getIops(),fluent.getKmsKeyARN(),fluent.getSize(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EC2RootVolumeBuilder that = (EC2RootVolumeBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}