package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class MachinePoolPlatformBuilder extends io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatformFluentImpl<io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatformBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatform,io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatformBuilder>{
  public MachinePoolPlatformBuilder() {
    this(false);
  }
  public MachinePoolPlatformBuilder(java.lang.Boolean validationEnabled) {
    this(new MachinePoolPlatform(), validationEnabled);
  }
  public MachinePoolPlatformBuilder(io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolPlatformBuilder(io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatformFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MachinePoolPlatform(), validationEnabled);
  }
  public MachinePoolPlatformBuilder(io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatformFluent<?> fluent,io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatform instance) {
    this(fluent, instance, false);
  }
  public MachinePoolPlatformBuilder(io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatformFluent<?> fluent,io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatform instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRootVolume(instance.getRootVolume()); 
    fluent.withSpotMarketOptions(instance.getSpotMarketOptions()); 
    fluent.withSubnets(instance.getSubnets()); 
    fluent.withType(instance.getType()); 
    fluent.withZones(instance.getZones()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolPlatformBuilder(io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatform instance) {
    this(instance,false);
  }
  public MachinePoolPlatformBuilder(io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatform instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRootVolume(instance.getRootVolume()); 
    this.withSpotMarketOptions(instance.getSpotMarketOptions()); 
    this.withSubnets(instance.getSubnets()); 
    this.withType(instance.getType()); 
    this.withZones(instance.getZones()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatformFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatform build() {
    MachinePoolPlatform buildable = new MachinePoolPlatform(fluent.getRootVolume(),fluent.getSpotMarketOptions(),fluent.getSubnets(),fluent.getType(),fluent.getZones());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolPlatformBuilder that = (MachinePoolPlatformBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}