package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AWSPrivateLinkInventoryBuilder extends io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventoryFluentImpl<io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventoryBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventory,io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventoryBuilder>{
  public AWSPrivateLinkInventoryBuilder() {
    this(false);
  }
  public AWSPrivateLinkInventoryBuilder(java.lang.Boolean validationEnabled) {
    this(new AWSPrivateLinkInventory(), validationEnabled);
  }
  public AWSPrivateLinkInventoryBuilder(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventoryFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSPrivateLinkInventoryBuilder(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventoryFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AWSPrivateLinkInventory(), validationEnabled);
  }
  public AWSPrivateLinkInventoryBuilder(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventoryFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventory instance) {
    this(fluent, instance, false);
  }
  public AWSPrivateLinkInventoryBuilder(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventoryFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventory instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRegion(instance.getRegion()); 
    fluent.withSubnets(instance.getSubnets()); 
    fluent.withVpcID(instance.getVpcID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AWSPrivateLinkInventoryBuilder(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventory instance) {
    this(instance,false);
  }
  public AWSPrivateLinkInventoryBuilder(io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventory instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRegion(instance.getRegion()); 
    this.withSubnets(instance.getSubnets()); 
    this.withVpcID(instance.getVpcID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventoryFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventory build() {
    AWSPrivateLinkInventory buildable = new AWSPrivateLinkInventory(fluent.getRegion(),fluent.getSubnets(),fluent.getVpcID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSPrivateLinkInventoryBuilder that = (AWSPrivateLinkInventoryBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}