package io.fabric8.openshift.api.model.hive.v1;

import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import io.fabric8.kubernetes.api.model.rbac.Subject;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public class ClusterClaimSpecFluentImpl<A extends io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpecFluent<A>{
  public ClusterClaimSpecFluentImpl() {
  }
  public ClusterClaimSpecFluentImpl(io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpec instance) {
    this.withClusterPoolName(instance.getClusterPoolName()); 
    this.withLifetime(instance.getLifetime()); 
    this.withNamespace(instance.getNamespace()); 
    this.withSubjects(instance.getSubjects()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.String clusterPoolName;
  private io.fabric8.kubernetes.api.model.Duration lifetime;
  private java.lang.String namespace;
  private java.util.List<io.fabric8.kubernetes.api.model.rbac.Subject> subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.rbac.Subject>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.String getClusterPoolName() {
    return this.clusterPoolName;
  }
  public A withClusterPoolName(java.lang.String clusterPoolName) {
    this.clusterPoolName=clusterPoolName; return (A) this;
  }
  public java.lang.Boolean hasClusterPoolName() {
    return this.clusterPoolName != null;
  }
  
  /**
   * Method is deprecated. use withClusterPoolName instead.
   */
  @java.lang.Deprecated
  public A withNewClusterPoolName(java.lang.String arg0) {
    return (A)withClusterPoolName(new String(arg0));
  }
  public io.fabric8.kubernetes.api.model.Duration getLifetime() {
    return this.lifetime;
  }
  public A withLifetime(io.fabric8.kubernetes.api.model.Duration lifetime) {
    this.lifetime=lifetime; return (A) this;
  }
  public java.lang.Boolean hasLifetime() {
    return this.lifetime != null;
  }
  public java.lang.String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(java.lang.String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public java.lang.Boolean hasNamespace() {
    return this.namespace != null;
  }
  
  /**
   * Method is deprecated. use withNamespace instead.
   */
  @java.lang.Deprecated
  public A withNewNamespace(java.lang.String arg0) {
    return (A)withNamespace(new String(arg0));
  }
  public A addToSubjects(java.lang.Integer index,io.fabric8.kubernetes.api.model.rbac.Subject item) {
    if (this.subjects == null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.rbac.Subject>();}
    this.subjects.add(index, item);
    return (A)this;
  }
  public A setToSubjects(java.lang.Integer index,io.fabric8.kubernetes.api.model.rbac.Subject item) {
    if (this.subjects == null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.rbac.Subject>();}
    this.subjects.set(index, item); return (A)this;
  }
  public A addToSubjects(io.fabric8.kubernetes.api.model.rbac.Subject... items) {
    if (this.subjects == null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.rbac.Subject>();}
    for (io.fabric8.kubernetes.api.model.rbac.Subject item : items) {this.subjects.add(item);} return (A)this;
  }
  public A addAllToSubjects(java.util.Collection<io.fabric8.kubernetes.api.model.rbac.Subject> items) {
    if (this.subjects == null) {this.subjects = new java.util.ArrayList<io.fabric8.kubernetes.api.model.rbac.Subject>();}
    for (io.fabric8.kubernetes.api.model.rbac.Subject item : items) {this.subjects.add(item);} return (A)this;
  }
  public A removeFromSubjects(io.fabric8.kubernetes.api.model.rbac.Subject... items) {
    for (io.fabric8.kubernetes.api.model.rbac.Subject item : items) {if (this.subjects!= null){ this.subjects.remove(item);}} return (A)this;
  }
  public A removeAllFromSubjects(java.util.Collection<io.fabric8.kubernetes.api.model.rbac.Subject> items) {
    for (io.fabric8.kubernetes.api.model.rbac.Subject item : items) {if (this.subjects!= null){ this.subjects.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.rbac.Subject> getSubjects() {
    return this.subjects;
  }
  public io.fabric8.kubernetes.api.model.rbac.Subject getSubject(java.lang.Integer index) {
    return this.subjects.get(index);
  }
  public io.fabric8.kubernetes.api.model.rbac.Subject getFirstSubject() {
    return this.subjects.get(0);
  }
  public io.fabric8.kubernetes.api.model.rbac.Subject getLastSubject() {
    return this.subjects.get(subjects.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.rbac.Subject getMatchingSubject(java.util.function.Predicate<io.fabric8.kubernetes.api.model.rbac.Subject> predicate) {
    for (io.fabric8.kubernetes.api.model.rbac.Subject item: subjects) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingSubject(java.util.function.Predicate<io.fabric8.kubernetes.api.model.rbac.Subject> predicate) {
    for (io.fabric8.kubernetes.api.model.rbac.Subject item: subjects) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubjects(java.util.List<io.fabric8.kubernetes.api.model.rbac.Subject> subjects) {
    if (subjects != null) {this.subjects = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.rbac.Subject item : subjects){this.addToSubjects(item);}} else { this.subjects = null;} return (A) this;
  }
  public A withSubjects(io.fabric8.kubernetes.api.model.rbac.Subject... subjects) {
    if (this.subjects != null) {this.subjects.clear();}
    if (subjects != null) {for (io.fabric8.kubernetes.api.model.rbac.Subject item :subjects){ this.addToSubjects(item);}} return (A) this;
  }
  public java.lang.Boolean hasSubjects() {
    return subjects != null && !subjects.isEmpty();
  }
  public A addNewSubject(java.lang.String apiGroup,java.lang.String kind,java.lang.String name,java.lang.String namespace) {
    return (A)addToSubjects(new Subject(apiGroup, kind, name, namespace));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterClaimSpecFluentImpl that = (ClusterClaimSpecFluentImpl) o;
    if (clusterPoolName != null ? !clusterPoolName.equals(that.clusterPoolName) :that.clusterPoolName != null) return false;
    if (lifetime != null ? !lifetime.equals(that.lifetime) :that.lifetime != null) return false;
    if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
    if (subjects != null ? !subjects.equals(that.subjects) :that.subjects != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterPoolName,  lifetime,  namespace,  subjects,  additionalProperties,  super.hashCode());
  }
  
}