package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClusterImageSetSpecBuilder extends io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpecFluentImpl<io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpec,io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpecBuilder>{
  public ClusterImageSetSpecBuilder() {
    this(false);
  }
  public ClusterImageSetSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ClusterImageSetSpec(), validationEnabled);
  }
  public ClusterImageSetSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterImageSetSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterImageSetSpec(), validationEnabled);
  }
  public ClusterImageSetSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpecFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterImageSetSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpecFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withReleaseImage(instance.getReleaseImage()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterImageSetSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpec instance) {
    this(instance,false);
  }
  public ClusterImageSetSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withReleaseImage(instance.getReleaseImage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.ClusterImageSetSpec build() {
    ClusterImageSetSpec buildable = new ClusterImageSetSpec(fluent.getReleaseImage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterImageSetSpecBuilder that = (ClusterImageSetSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}