package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClusterIngressBuilder extends io.fabric8.openshift.api.model.hive.v1.ClusterIngressFluentImpl<io.fabric8.openshift.api.model.hive.v1.ClusterIngressBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.ClusterIngress,io.fabric8.openshift.api.model.hive.v1.ClusterIngressBuilder>{
  public ClusterIngressBuilder() {
    this(false);
  }
  public ClusterIngressBuilder(java.lang.Boolean validationEnabled) {
    this(new ClusterIngress(), validationEnabled);
  }
  public ClusterIngressBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterIngressFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterIngressBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterIngressFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterIngress(), validationEnabled);
  }
  public ClusterIngressBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterIngressFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.ClusterIngress instance) {
    this(fluent, instance, false);
  }
  public ClusterIngressBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterIngressFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.ClusterIngress instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDomain(instance.getDomain()); 
    fluent.withName(instance.getName()); 
    fluent.withNamespaceSelector(instance.getNamespaceSelector()); 
    fluent.withRouteSelector(instance.getRouteSelector()); 
    fluent.withServingCertificate(instance.getServingCertificate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterIngressBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterIngress instance) {
    this(instance,false);
  }
  public ClusterIngressBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterIngress instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDomain(instance.getDomain()); 
    this.withName(instance.getName()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withRouteSelector(instance.getRouteSelector()); 
    this.withServingCertificate(instance.getServingCertificate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.ClusterIngressFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.ClusterIngress build() {
    ClusterIngress buildable = new ClusterIngress(fluent.getDomain(),fluent.getName(),fluent.getNamespaceSelector(),fluent.getRouteSelector(),fluent.getServingCertificate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterIngressBuilder that = (ClusterIngressBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}