package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClusterMetadataBuilder extends io.fabric8.openshift.api.model.hive.v1.ClusterMetadataFluentImpl<io.fabric8.openshift.api.model.hive.v1.ClusterMetadataBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.ClusterMetadata,io.fabric8.openshift.api.model.hive.v1.ClusterMetadataBuilder>{
  public ClusterMetadataBuilder() {
    this(false);
  }
  public ClusterMetadataBuilder(java.lang.Boolean validationEnabled) {
    this(new ClusterMetadata(), validationEnabled);
  }
  public ClusterMetadataBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterMetadataFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterMetadataBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterMetadataFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterMetadata(), validationEnabled);
  }
  public ClusterMetadataBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterMetadataFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.ClusterMetadata instance) {
    this(fluent, instance, false);
  }
  public ClusterMetadataBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterMetadataFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.ClusterMetadata instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdminKubeconfigSecretRef(instance.getAdminKubeconfigSecretRef()); 
    fluent.withAdminPasswordSecretRef(instance.getAdminPasswordSecretRef()); 
    fluent.withClusterID(instance.getClusterID()); 
    fluent.withInfraID(instance.getInfraID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterMetadataBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterMetadata instance) {
    this(instance,false);
  }
  public ClusterMetadataBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterMetadata instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdminKubeconfigSecretRef(instance.getAdminKubeconfigSecretRef()); 
    this.withAdminPasswordSecretRef(instance.getAdminPasswordSecretRef()); 
    this.withClusterID(instance.getClusterID()); 
    this.withInfraID(instance.getInfraID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.ClusterMetadataFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.ClusterMetadata build() {
    ClusterMetadata buildable = new ClusterMetadata(fluent.getAdminKubeconfigSecretRef(),fluent.getAdminPasswordSecretRef(),fluent.getClusterID(),fluent.getInfraID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterMetadataBuilder that = (ClusterMetadataBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}