package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClusterRelocateSpecBuilder extends io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpecFluentImpl<io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpec,io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpecBuilder>{
  public ClusterRelocateSpecBuilder() {
    this(false);
  }
  public ClusterRelocateSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new ClusterRelocateSpec(), validationEnabled);
  }
  public ClusterRelocateSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRelocateSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClusterRelocateSpec(), validationEnabled);
  }
  public ClusterRelocateSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpecFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterRelocateSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpecFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterDeploymentSelector(instance.getClusterDeploymentSelector()); 
    fluent.withKubeconfigSecretRef(instance.getKubeconfigSecretRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterRelocateSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpec instance) {
    this(instance,false);
  }
  public ClusterRelocateSpecBuilder(io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector()); 
    this.withKubeconfigSecretRef(instance.getKubeconfigSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.ClusterRelocateSpec build() {
    ClusterRelocateSpec buildable = new ClusterRelocateSpec(fluent.getClusterDeploymentSelector(),fluent.getKubeconfigSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterRelocateSpecBuilder that = (ClusterRelocateSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}