package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class MachinePoolAutoscalingBuilder extends io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscalingFluentImpl<io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscalingBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscaling,io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscalingBuilder>{
  public MachinePoolAutoscalingBuilder() {
    this(false);
  }
  public MachinePoolAutoscalingBuilder(java.lang.Boolean validationEnabled) {
    this(new MachinePoolAutoscaling(), validationEnabled);
  }
  public MachinePoolAutoscalingBuilder(io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscalingFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolAutoscalingBuilder(io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscalingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MachinePoolAutoscaling(), validationEnabled);
  }
  public MachinePoolAutoscalingBuilder(io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscalingFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscaling instance) {
    this(fluent, instance, false);
  }
  public MachinePoolAutoscalingBuilder(io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscalingFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscaling instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMaxReplicas(instance.getMaxReplicas()); 
    fluent.withMinReplicas(instance.getMinReplicas()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolAutoscalingBuilder(io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscaling instance) {
    this(instance,false);
  }
  public MachinePoolAutoscalingBuilder(io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscaling instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMaxReplicas(instance.getMaxReplicas()); 
    this.withMinReplicas(instance.getMinReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscalingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.MachinePoolAutoscaling build() {
    MachinePoolAutoscaling buildable = new MachinePoolAutoscaling(fluent.getMaxReplicas(),fluent.getMinReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachinePoolAutoscalingBuilder that = (MachinePoolAutoscalingBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}