package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class BackupReferenceBuilder extends io.fabric8.openshift.api.model.hive.v1.BackupReferenceFluentImpl<io.fabric8.openshift.api.model.hive.v1.BackupReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.BackupReference,io.fabric8.openshift.api.model.hive.v1.BackupReferenceBuilder>{
  public BackupReferenceBuilder() {
    this(false);
  }
  public BackupReferenceBuilder(java.lang.Boolean validationEnabled) {
    this(new BackupReference(), validationEnabled);
  }
  public BackupReferenceBuilder(io.fabric8.openshift.api.model.hive.v1.BackupReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public BackupReferenceBuilder(io.fabric8.openshift.api.model.hive.v1.BackupReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new BackupReference(), validationEnabled);
  }
  public BackupReferenceBuilder(io.fabric8.openshift.api.model.hive.v1.BackupReferenceFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.BackupReference instance) {
    this(fluent, instance, false);
  }
  public BackupReferenceBuilder(io.fabric8.openshift.api.model.hive.v1.BackupReferenceFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.BackupReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BackupReferenceBuilder(io.fabric8.openshift.api.model.hive.v1.BackupReference instance) {
    this(instance,false);
  }
  public BackupReferenceBuilder(io.fabric8.openshift.api.model.hive.v1.BackupReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.BackupReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.BackupReference build() {
    BackupReference buildable = new BackupReference(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BackupReferenceBuilder that = (BackupReferenceBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}