package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class AWSServiceProviderCredentialsBuilder extends io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentialsFluentImpl<io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentialsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentials,io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentialsBuilder>{
  public AWSServiceProviderCredentialsBuilder() {
    this(false);
  }
  public AWSServiceProviderCredentialsBuilder(java.lang.Boolean validationEnabled) {
    this(new AWSServiceProviderCredentials(), validationEnabled);
  }
  public AWSServiceProviderCredentialsBuilder(io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentialsFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSServiceProviderCredentialsBuilder(io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentialsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new AWSServiceProviderCredentials(), validationEnabled);
  }
  public AWSServiceProviderCredentialsBuilder(io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentialsFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentials instance) {
    this(fluent, instance, false);
  }
  public AWSServiceProviderCredentialsBuilder(io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentialsFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentials instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AWSServiceProviderCredentialsBuilder(io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentials instance) {
    this(instance,false);
  }
  public AWSServiceProviderCredentialsBuilder(io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentials instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentialsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.AWSServiceProviderCredentials build() {
    AWSServiceProviderCredentials buildable = new AWSServiceProviderCredentials(fluent.getCredentialsSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AWSServiceProviderCredentialsBuilder that = (AWSServiceProviderCredentialsBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}