package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class PrivateLinkAccessStatusBuilder extends io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatusFluentImpl<io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatus,io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatusBuilder>{
  public PrivateLinkAccessStatusBuilder() {
    this(false);
  }
  public PrivateLinkAccessStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new PrivateLinkAccessStatus(), validationEnabled);
  }
  public PrivateLinkAccessStatusBuilder(io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PrivateLinkAccessStatusBuilder(io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PrivateLinkAccessStatus(), validationEnabled);
  }
  public PrivateLinkAccessStatusBuilder(io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatusFluent<?> fluent,io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatus instance) {
    this(fluent, instance, false);
  }
  public PrivateLinkAccessStatusBuilder(io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatusFluent<?> fluent,io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHostedZoneID(instance.getHostedZoneID()); 
    fluent.withVpcEndpointID(instance.getVpcEndpointID()); 
    fluent.withVpcEndpointService(instance.getVpcEndpointService()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PrivateLinkAccessStatusBuilder(io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatus instance) {
    this(instance,false);
  }
  public PrivateLinkAccessStatusBuilder(io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHostedZoneID(instance.getHostedZoneID()); 
    this.withVpcEndpointID(instance.getVpcEndpointID()); 
    this.withVpcEndpointService(instance.getVpcEndpointService()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatus build() {
    PrivateLinkAccessStatus buildable = new PrivateLinkAccessStatus(fluent.getHostedZoneID(),fluent.getVpcEndpointID(),fluent.getVpcEndpointService());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PrivateLinkAccessStatusBuilder that = (PrivateLinkAccessStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}