package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class HiveConfigStatusBuilder extends io.fabric8.openshift.api.model.hive.v1.HiveConfigStatusFluentImpl<io.fabric8.openshift.api.model.hive.v1.HiveConfigStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.hive.v1.HiveConfigStatus,io.fabric8.openshift.api.model.hive.v1.HiveConfigStatusBuilder>{
  public HiveConfigStatusBuilder() {
    this(false);
  }
  public HiveConfigStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new HiveConfigStatus(), validationEnabled);
  }
  public HiveConfigStatusBuilder(io.fabric8.openshift.api.model.hive.v1.HiveConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public HiveConfigStatusBuilder(io.fabric8.openshift.api.model.hive.v1.HiveConfigStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HiveConfigStatus(), validationEnabled);
  }
  public HiveConfigStatusBuilder(io.fabric8.openshift.api.model.hive.v1.HiveConfigStatusFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.HiveConfigStatus instance) {
    this(fluent, instance, false);
  }
  public HiveConfigStatusBuilder(io.fabric8.openshift.api.model.hive.v1.HiveConfigStatusFluent<?> fluent,io.fabric8.openshift.api.model.hive.v1.HiveConfigStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAggregatorClientCAHash(instance.getAggregatorClientCAHash()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withConfigApplied(instance.getConfigApplied()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HiveConfigStatusBuilder(io.fabric8.openshift.api.model.hive.v1.HiveConfigStatus instance) {
    this(instance,false);
  }
  public HiveConfigStatusBuilder(io.fabric8.openshift.api.model.hive.v1.HiveConfigStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAggregatorClientCAHash(instance.getAggregatorClientCAHash()); 
    this.withConditions(instance.getConditions()); 
    this.withConfigApplied(instance.getConfigApplied()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.hive.v1.HiveConfigStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.hive.v1.HiveConfigStatus build() {
    HiveConfigStatus buildable = new HiveConfigStatus(fluent.getAggregatorClientCAHash(),fluent.getConditions(),fluent.getConfigApplied(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HiveConfigStatusBuilder that = (HiveConfigStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}