/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolume;
import io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolumeBuilder;
import io.fabric8.openshift.api.model.hive.aws.v1.EC2RootVolumeFluentImpl;
import io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatform;
import io.fabric8.openshift.api.model.hive.aws.v1.MachinePoolPlatformFluent;
import io.fabric8.openshift.api.model.hive.aws.v1.SpotMarketOptions;
import io.fabric8.openshift.api.model.hive.aws.v1.SpotMarketOptionsBuilder;
import io.fabric8.openshift.api.model.hive.aws.v1.SpotMarketOptionsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachinePoolPlatformFluentImpl<A extends MachinePoolPlatformFluent<A>>
extends BaseFluent<A>
implements MachinePoolPlatformFluent<A> {
    private EC2RootVolumeBuilder rootVolume;
    private SpotMarketOptionsBuilder spotMarketOptions;
    private List<String> subnets = new ArrayList<String>();
    private String type;
    private List<String> zones = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public MachinePoolPlatformFluentImpl() {
    }

    public MachinePoolPlatformFluentImpl(MachinePoolPlatform instance) {
        this.withRootVolume(instance.getRootVolume());
        this.withSpotMarketOptions(instance.getSpotMarketOptions());
        this.withSubnets(instance.getSubnets());
        this.withType(instance.getType());
        this.withZones(instance.getZones());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public EC2RootVolume getRootVolume() {
        return this.rootVolume != null ? this.rootVolume.build() : null;
    }

    @Override
    public EC2RootVolume buildRootVolume() {
        return this.rootVolume != null ? this.rootVolume.build() : null;
    }

    @Override
    public A withRootVolume(EC2RootVolume rootVolume) {
        this._visitables.get((Object)"rootVolume").remove(this.rootVolume);
        if (rootVolume != null) {
            this.rootVolume = new EC2RootVolumeBuilder(rootVolume);
            this._visitables.get((Object)"rootVolume").add(this.rootVolume);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRootVolume() {
        return this.rootVolume != null;
    }

    @Override
    public A withNewRootVolume(Integer iops, String kmsKeyARN, Integer size, String type) {
        return this.withRootVolume(new EC2RootVolume(iops, kmsKeyARN, size, type));
    }

    @Override
    public MachinePoolPlatformFluent.RootVolumeNested<A> withNewRootVolume() {
        return new RootVolumeNestedImpl();
    }

    @Override
    public MachinePoolPlatformFluent.RootVolumeNested<A> withNewRootVolumeLike(EC2RootVolume item) {
        return new RootVolumeNestedImpl(item);
    }

    @Override
    public MachinePoolPlatformFluent.RootVolumeNested<A> editRootVolume() {
        return this.withNewRootVolumeLike(this.getRootVolume());
    }

    @Override
    public MachinePoolPlatformFluent.RootVolumeNested<A> editOrNewRootVolume() {
        return this.withNewRootVolumeLike(this.getRootVolume() != null ? this.getRootVolume() : new EC2RootVolumeBuilder().build());
    }

    @Override
    public MachinePoolPlatformFluent.RootVolumeNested<A> editOrNewRootVolumeLike(EC2RootVolume item) {
        return this.withNewRootVolumeLike(this.getRootVolume() != null ? this.getRootVolume() : item);
    }

    @Override
    @Deprecated
    public SpotMarketOptions getSpotMarketOptions() {
        return this.spotMarketOptions != null ? this.spotMarketOptions.build() : null;
    }

    @Override
    public SpotMarketOptions buildSpotMarketOptions() {
        return this.spotMarketOptions != null ? this.spotMarketOptions.build() : null;
    }

    @Override
    public A withSpotMarketOptions(SpotMarketOptions spotMarketOptions) {
        this._visitables.get((Object)"spotMarketOptions").remove(this.spotMarketOptions);
        if (spotMarketOptions != null) {
            this.spotMarketOptions = new SpotMarketOptionsBuilder(spotMarketOptions);
            this._visitables.get((Object)"spotMarketOptions").add(this.spotMarketOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpotMarketOptions() {
        return this.spotMarketOptions != null;
    }

    @Override
    public A withNewSpotMarketOptions(String maxPrice) {
        return this.withSpotMarketOptions(new SpotMarketOptions(maxPrice));
    }

    @Override
    public MachinePoolPlatformFluent.SpotMarketOptionsNested<A> withNewSpotMarketOptions() {
        return new SpotMarketOptionsNestedImpl();
    }

    @Override
    public MachinePoolPlatformFluent.SpotMarketOptionsNested<A> withNewSpotMarketOptionsLike(SpotMarketOptions item) {
        return new SpotMarketOptionsNestedImpl(item);
    }

    @Override
    public MachinePoolPlatformFluent.SpotMarketOptionsNested<A> editSpotMarketOptions() {
        return this.withNewSpotMarketOptionsLike(this.getSpotMarketOptions());
    }

    @Override
    public MachinePoolPlatformFluent.SpotMarketOptionsNested<A> editOrNewSpotMarketOptions() {
        return this.withNewSpotMarketOptionsLike(this.getSpotMarketOptions() != null ? this.getSpotMarketOptions() : new SpotMarketOptionsBuilder().build());
    }

    @Override
    public MachinePoolPlatformFluent.SpotMarketOptionsNested<A> editOrNewSpotMarketOptionsLike(SpotMarketOptions item) {
        return this.withNewSpotMarketOptionsLike(this.getSpotMarketOptions() != null ? this.getSpotMarketOptions() : item);
    }

    @Override
    public A addToSubnets(Integer index, String item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSubnets(Integer index, String item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSubnets(String ... items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubnets(Collection<String> items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubnets(String ... items) {
        for (String item : items) {
            if (this.subnets == null) continue;
            this.subnets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubnets(Collection<String> items) {
        for (String item : items) {
            if (this.subnets == null) continue;
            this.subnets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSubnets() {
        return this.subnets;
    }

    @Override
    public String getSubnet(Integer index) {
        return this.subnets.get(index);
    }

    @Override
    public String getFirstSubnet() {
        return this.subnets.get(0);
    }

    @Override
    public String getLastSubnet() {
        return this.subnets.get(this.subnets.size() - 1);
    }

    @Override
    public String getMatchingSubnet(Predicate<String> predicate) {
        for (String item : this.subnets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubnet(Predicate<String> predicate) {
        for (String item : this.subnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubnets(List<String> subnets) {
        if (subnets != null) {
            this.subnets = new ArrayList<String>();
            for (String item : subnets) {
                this.addToSubnets(item);
            }
        } else {
            this.subnets = null;
        }
        return (A)this;
    }

    @Override
    public A withSubnets(String ... subnets) {
        if (this.subnets != null) {
            this.subnets.clear();
        }
        if (subnets != null) {
            for (String item : subnets) {
                this.addToSubnets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubnets() {
        return this.subnets != null && !this.subnets.isEmpty();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public A addToZones(Integer index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.add(index, item);
        return (A)this;
    }

    @Override
    public A setToZones(Integer index, String item) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        this.zones.set(index, item);
        return (A)this;
    }

    @Override
    public A addToZones(String ... items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToZones(Collection<String> items) {
        if (this.zones == null) {
            this.zones = new ArrayList<String>();
        }
        for (String item : items) {
            this.zones.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromZones(String ... items) {
        for (String item : items) {
            if (this.zones == null) continue;
            this.zones.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromZones(Collection<String> items) {
        for (String item : items) {
            if (this.zones == null) continue;
            this.zones.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getZones() {
        return this.zones;
    }

    @Override
    public String getZone(Integer index) {
        return this.zones.get(index);
    }

    @Override
    public String getFirstZone() {
        return this.zones.get(0);
    }

    @Override
    public String getLastZone() {
        return this.zones.get(this.zones.size() - 1);
    }

    @Override
    public String getMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingZone(Predicate<String> predicate) {
        for (String item : this.zones) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withZones(List<String> zones) {
        if (zones != null) {
            this.zones = new ArrayList<String>();
            for (String item : zones) {
                this.addToZones(item);
            }
        } else {
            this.zones = null;
        }
        return (A)this;
    }

    @Override
    public A withZones(String ... zones) {
        if (this.zones != null) {
            this.zones.clear();
        }
        if (zones != null) {
            for (String item : zones) {
                this.addToZones(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasZones() {
        return this.zones != null && !this.zones.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachinePoolPlatformFluentImpl that = (MachinePoolPlatformFluentImpl)o;
        if (this.rootVolume != null ? !this.rootVolume.equals(that.rootVolume) : that.rootVolume != null) {
            return false;
        }
        if (this.spotMarketOptions != null ? !this.spotMarketOptions.equals(that.spotMarketOptions) : that.spotMarketOptions != null) {
            return false;
        }
        if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.zones != null ? !this.zones.equals(that.zones) : that.zones != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.rootVolume, this.spotMarketOptions, this.subnets, this.type, this.zones, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.rootVolume != null) {
            sb.append("rootVolume:");
            sb.append(this.rootVolume + ",");
        }
        if (this.spotMarketOptions != null) {
            sb.append("spotMarketOptions:");
            sb.append(this.spotMarketOptions + ",");
        }
        if (this.subnets != null && !this.subnets.isEmpty()) {
            sb.append("subnets:");
            sb.append(this.subnets + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.zones != null && !this.zones.isEmpty()) {
            sb.append("zones:");
            sb.append(this.zones + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SpotMarketOptionsNestedImpl<N>
    extends SpotMarketOptionsFluentImpl<MachinePoolPlatformFluent.SpotMarketOptionsNested<N>>
    implements MachinePoolPlatformFluent.SpotMarketOptionsNested<N>,
    Nested<N> {
        SpotMarketOptionsBuilder builder;

        SpotMarketOptionsNestedImpl(SpotMarketOptions item) {
            this.builder = new SpotMarketOptionsBuilder(this, item);
        }

        SpotMarketOptionsNestedImpl() {
            this.builder = new SpotMarketOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolPlatformFluentImpl.this.withSpotMarketOptions(this.builder.build());
        }

        @Override
        public N endSpotMarketOptions() {
            return this.and();
        }
    }

    class RootVolumeNestedImpl<N>
    extends EC2RootVolumeFluentImpl<MachinePoolPlatformFluent.RootVolumeNested<N>>
    implements MachinePoolPlatformFluent.RootVolumeNested<N>,
    Nested<N> {
        EC2RootVolumeBuilder builder;

        RootVolumeNestedImpl(EC2RootVolume item) {
            this.builder = new EC2RootVolumeBuilder(this, item);
        }

        RootVolumeNestedImpl() {
            this.builder = new EC2RootVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolPlatformFluentImpl.this.withRootVolume(this.builder.build());
        }

        @Override
        public N endRootVolume() {
            return this.and();
        }
    }
}

