/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.SecretMapping;
import io.fabric8.openshift.api.model.hive.v1.SecretMappingBuilder;
import io.fabric8.openshift.api.model.hive.v1.SecretMappingFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.SelectorSyncSetSpec;
import io.fabric8.openshift.api.model.hive.v1.SelectorSyncSetSpecFluent;
import io.fabric8.openshift.api.model.hive.v1.SyncObjectPatch;
import io.fabric8.openshift.api.model.hive.v1.SyncObjectPatchBuilder;
import io.fabric8.openshift.api.model.hive.v1.SyncObjectPatchFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SelectorSyncSetSpecFluentImpl<A extends SelectorSyncSetSpecFluent<A>>
extends BaseFluent<A>
implements SelectorSyncSetSpecFluent<A> {
    private String applyBehavior;
    private LabelSelectorBuilder clusterDeploymentSelector;
    private ArrayList<SyncObjectPatchBuilder> patches = new ArrayList();
    private String resourceApplyMode;
    private List<Map<String, Object>> resources = new ArrayList<Map<String, Object>>();
    private ArrayList<SecretMappingBuilder> secretMappings = new ArrayList();
    private Map<String, Object> additionalProperties;

    public SelectorSyncSetSpecFluentImpl() {
    }

    public SelectorSyncSetSpecFluentImpl(SelectorSyncSetSpec instance) {
        this.withApplyBehavior(instance.getApplyBehavior());
        this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
        this.withPatches(instance.getPatches());
        this.withResourceApplyMode(instance.getResourceApplyMode());
        this.withResources(instance.getResources());
        this.withSecretMappings(instance.getSecretMappings());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApplyBehavior() {
        return this.applyBehavior;
    }

    @Override
    public A withApplyBehavior(String applyBehavior) {
        this.applyBehavior = applyBehavior;
        return (A)this;
    }

    @Override
    public Boolean hasApplyBehavior() {
        return this.applyBehavior != null;
    }

    @Override
    @Deprecated
    public LabelSelector getClusterDeploymentSelector() {
        return this.clusterDeploymentSelector != null ? this.clusterDeploymentSelector.build() : null;
    }

    @Override
    public LabelSelector buildClusterDeploymentSelector() {
        return this.clusterDeploymentSelector != null ? this.clusterDeploymentSelector.build() : null;
    }

    @Override
    public A withClusterDeploymentSelector(LabelSelector clusterDeploymentSelector) {
        this._visitables.get((Object)"clusterDeploymentSelector").remove(this.clusterDeploymentSelector);
        if (clusterDeploymentSelector != null) {
            this.clusterDeploymentSelector = new LabelSelectorBuilder(clusterDeploymentSelector);
            this._visitables.get((Object)"clusterDeploymentSelector").add(this.clusterDeploymentSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterDeploymentSelector() {
        return this.clusterDeploymentSelector != null;
    }

    @Override
    public SelectorSyncSetSpecFluent.ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelector() {
        return new ClusterDeploymentSelectorNestedImpl();
    }

    @Override
    public SelectorSyncSetSpecFluent.ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelectorLike(LabelSelector item) {
        return new ClusterDeploymentSelectorNestedImpl(item);
    }

    @Override
    public SelectorSyncSetSpecFluent.ClusterDeploymentSelectorNested<A> editClusterDeploymentSelector() {
        return this.withNewClusterDeploymentSelectorLike(this.getClusterDeploymentSelector());
    }

    @Override
    public SelectorSyncSetSpecFluent.ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelector() {
        return this.withNewClusterDeploymentSelectorLike(this.getClusterDeploymentSelector() != null ? this.getClusterDeploymentSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public SelectorSyncSetSpecFluent.ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelectorLike(LabelSelector item) {
        return this.withNewClusterDeploymentSelectorLike(this.getClusterDeploymentSelector() != null ? this.getClusterDeploymentSelector() : item);
    }

    @Override
    public A addToPatches(Integer index, SyncObjectPatch item) {
        if (this.patches == null) {
            this.patches = new ArrayList();
        }
        SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
        this._visitables.get((Object)"patches").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"patches").size(), builder);
        this.patches.add(index >= 0 ? index.intValue() : this.patches.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPatches(Integer index, SyncObjectPatch item) {
        if (this.patches == null) {
            this.patches = new ArrayList();
        }
        SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"patches").size()) {
            this._visitables.get((Object)"patches").add(builder);
        } else {
            this._visitables.get((Object)"patches").set(index, builder);
        }
        if (index < 0 || index >= this.patches.size()) {
            this.patches.add(builder);
        } else {
            this.patches.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPatches(SyncObjectPatch ... items) {
        if (this.patches == null) {
            this.patches = new ArrayList();
        }
        for (SyncObjectPatch item : items) {
            SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
            this._visitables.get((Object)"patches").add(builder);
            this.patches.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPatches(Collection<SyncObjectPatch> items) {
        if (this.patches == null) {
            this.patches = new ArrayList();
        }
        for (SyncObjectPatch item : items) {
            SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
            this._visitables.get((Object)"patches").add(builder);
            this.patches.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPatches(SyncObjectPatch ... items) {
        for (SyncObjectPatch item : items) {
            SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
            this._visitables.get((Object)"patches").remove(builder);
            if (this.patches == null) continue;
            this.patches.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPatches(Collection<SyncObjectPatch> items) {
        for (SyncObjectPatch item : items) {
            SyncObjectPatchBuilder builder = new SyncObjectPatchBuilder(item);
            this._visitables.get((Object)"patches").remove(builder);
            if (this.patches == null) continue;
            this.patches.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPatches(Predicate<SyncObjectPatchBuilder> predicate) {
        if (this.patches == null) {
            return (A)this;
        }
        Iterator<SyncObjectPatchBuilder> each = this.patches.iterator();
        List visitables = this._visitables.get((Object)"patches");
        while (each.hasNext()) {
            SyncObjectPatchBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SyncObjectPatch> getPatches() {
        return this.patches != null ? SelectorSyncSetSpecFluentImpl.build(this.patches) : null;
    }

    @Override
    public List<SyncObjectPatch> buildPatches() {
        return this.patches != null ? SelectorSyncSetSpecFluentImpl.build(this.patches) : null;
    }

    @Override
    public SyncObjectPatch buildPatch(Integer index) {
        return this.patches.get(index).build();
    }

    @Override
    public SyncObjectPatch buildFirstPatch() {
        return this.patches.get(0).build();
    }

    @Override
    public SyncObjectPatch buildLastPatch() {
        return this.patches.get(this.patches.size() - 1).build();
    }

    @Override
    public SyncObjectPatch buildMatchingPatch(Predicate<SyncObjectPatchBuilder> predicate) {
        for (SyncObjectPatchBuilder item : this.patches) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPatch(Predicate<SyncObjectPatchBuilder> predicate) {
        for (SyncObjectPatchBuilder item : this.patches) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPatches(List<SyncObjectPatch> patches) {
        if (this.patches != null) {
            this._visitables.get((Object)"patches").removeAll(this.patches);
        }
        if (patches != null) {
            this.patches = new ArrayList();
            for (SyncObjectPatch item : patches) {
                this.addToPatches(item);
            }
        } else {
            this.patches = null;
        }
        return (A)this;
    }

    @Override
    public A withPatches(SyncObjectPatch ... patches) {
        if (this.patches != null) {
            this.patches.clear();
        }
        if (patches != null) {
            for (SyncObjectPatch item : patches) {
                this.addToPatches(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPatches() {
        return this.patches != null && !this.patches.isEmpty();
    }

    @Override
    public SelectorSyncSetSpecFluent.PatchesNested<A> addNewPatch() {
        return new PatchesNestedImpl();
    }

    @Override
    public SelectorSyncSetSpecFluent.PatchesNested<A> addNewPatchLike(SyncObjectPatch item) {
        return new PatchesNestedImpl(-1, item);
    }

    @Override
    public SelectorSyncSetSpecFluent.PatchesNested<A> setNewPatchLike(Integer index, SyncObjectPatch item) {
        return new PatchesNestedImpl(index, item);
    }

    @Override
    public SelectorSyncSetSpecFluent.PatchesNested<A> editPatch(Integer index) {
        if (this.patches.size() <= index) {
            throw new RuntimeException("Can't edit patches. Index exceeds size.");
        }
        return this.setNewPatchLike(index, this.buildPatch(index));
    }

    @Override
    public SelectorSyncSetSpecFluent.PatchesNested<A> editFirstPatch() {
        if (this.patches.size() == 0) {
            throw new RuntimeException("Can't edit first patches. The list is empty.");
        }
        return this.setNewPatchLike(0, this.buildPatch(0));
    }

    @Override
    public SelectorSyncSetSpecFluent.PatchesNested<A> editLastPatch() {
        int index = this.patches.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last patches. The list is empty.");
        }
        return this.setNewPatchLike(index, this.buildPatch(index));
    }

    @Override
    public SelectorSyncSetSpecFluent.PatchesNested<A> editMatchingPatch(Predicate<SyncObjectPatchBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.patches.size(); ++i) {
            if (!predicate.test(this.patches.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching patches. No match found.");
        }
        return this.setNewPatchLike(index, this.buildPatch(index));
    }

    @Override
    public String getResourceApplyMode() {
        return this.resourceApplyMode;
    }

    @Override
    public A withResourceApplyMode(String resourceApplyMode) {
        this.resourceApplyMode = resourceApplyMode;
        return (A)this;
    }

    @Override
    public Boolean hasResourceApplyMode() {
        return this.resourceApplyMode != null;
    }

    @Override
    public A addToResources(Integer index, Map<String, Object> item) {
        if (this.resources == null) {
            this.resources = new ArrayList<Map<String, Object>>();
        }
        this.resources.add(index, item);
        return (A)this;
    }

    @Override
    public A setToResources(Integer index, Map<String, Object> item) {
        if (this.resources == null) {
            this.resources = new ArrayList<Map<String, Object>>();
        }
        this.resources.set(index, item);
        return (A)this;
    }

    @Override
    public A addToResources(Map<String, Object> ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<Map<String, Object>>();
        }
        for (Map<String, Object> item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<Map<String, Object>> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<Map<String, Object>>();
        }
        for (Map<String, Object> item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(Map<String, Object> ... items) {
        for (Map<String, Object> item : items) {
            if (this.resources == null) continue;
            this.resources.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<Map<String, Object>> items) {
        for (Map<String, Object> item : items) {
            if (this.resources == null) continue;
            this.resources.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Map<String, Object>> getResources() {
        return this.resources;
    }

    @Override
    public Map<String, Object> getResource(Integer index) {
        return this.resources.get(index);
    }

    @Override
    public Map<String, Object> getFirstResource() {
        return this.resources.get(0);
    }

    @Override
    public Map<String, Object> getLastResource() {
        return this.resources.get(this.resources.size() - 1);
    }

    @Override
    public Map<String, Object> getMatchingResource(Predicate<Map<String, Object>> predicate) {
        for (Map<String, Object> item : this.resources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<Map<String, Object>> predicate) {
        for (Map<String, Object> item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <K, V> A withResources(List<Map<String, Object>> resources) {
        if (resources != null) {
            this.resources = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(Map<String, Object> ... resources) {
        if (this.resources != null) {
            this.resources.clear();
        }
        if (resources != null) {
            for (Map<String, Object> item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public A addToSecretMappings(Integer index, SecretMapping item) {
        if (this.secretMappings == null) {
            this.secretMappings = new ArrayList();
        }
        SecretMappingBuilder builder = new SecretMappingBuilder(item);
        this._visitables.get((Object)"secretMappings").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"secretMappings").size(), builder);
        this.secretMappings.add(index >= 0 ? index.intValue() : this.secretMappings.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSecretMappings(Integer index, SecretMapping item) {
        if (this.secretMappings == null) {
            this.secretMappings = new ArrayList();
        }
        SecretMappingBuilder builder = new SecretMappingBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"secretMappings").size()) {
            this._visitables.get((Object)"secretMappings").add(builder);
        } else {
            this._visitables.get((Object)"secretMappings").set(index, builder);
        }
        if (index < 0 || index >= this.secretMappings.size()) {
            this.secretMappings.add(builder);
        } else {
            this.secretMappings.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSecretMappings(SecretMapping ... items) {
        if (this.secretMappings == null) {
            this.secretMappings = new ArrayList();
        }
        for (SecretMapping item : items) {
            SecretMappingBuilder builder = new SecretMappingBuilder(item);
            this._visitables.get((Object)"secretMappings").add(builder);
            this.secretMappings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecretMappings(Collection<SecretMapping> items) {
        if (this.secretMappings == null) {
            this.secretMappings = new ArrayList();
        }
        for (SecretMapping item : items) {
            SecretMappingBuilder builder = new SecretMappingBuilder(item);
            this._visitables.get((Object)"secretMappings").add(builder);
            this.secretMappings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecretMappings(SecretMapping ... items) {
        for (SecretMapping item : items) {
            SecretMappingBuilder builder = new SecretMappingBuilder(item);
            this._visitables.get((Object)"secretMappings").remove(builder);
            if (this.secretMappings == null) continue;
            this.secretMappings.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecretMappings(Collection<SecretMapping> items) {
        for (SecretMapping item : items) {
            SecretMappingBuilder builder = new SecretMappingBuilder(item);
            this._visitables.get((Object)"secretMappings").remove(builder);
            if (this.secretMappings == null) continue;
            this.secretMappings.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSecretMappings(Predicate<SecretMappingBuilder> predicate) {
        if (this.secretMappings == null) {
            return (A)this;
        }
        Iterator<SecretMappingBuilder> each = this.secretMappings.iterator();
        List visitables = this._visitables.get((Object)"secretMappings");
        while (each.hasNext()) {
            SecretMappingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SecretMapping> getSecretMappings() {
        return this.secretMappings != null ? SelectorSyncSetSpecFluentImpl.build(this.secretMappings) : null;
    }

    @Override
    public List<SecretMapping> buildSecretMappings() {
        return this.secretMappings != null ? SelectorSyncSetSpecFluentImpl.build(this.secretMappings) : null;
    }

    @Override
    public SecretMapping buildSecretMapping(Integer index) {
        return this.secretMappings.get(index).build();
    }

    @Override
    public SecretMapping buildFirstSecretMapping() {
        return this.secretMappings.get(0).build();
    }

    @Override
    public SecretMapping buildLastSecretMapping() {
        return this.secretMappings.get(this.secretMappings.size() - 1).build();
    }

    @Override
    public SecretMapping buildMatchingSecretMapping(Predicate<SecretMappingBuilder> predicate) {
        for (SecretMappingBuilder item : this.secretMappings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSecretMapping(Predicate<SecretMappingBuilder> predicate) {
        for (SecretMappingBuilder item : this.secretMappings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSecretMappings(List<SecretMapping> secretMappings) {
        if (this.secretMappings != null) {
            this._visitables.get((Object)"secretMappings").removeAll(this.secretMappings);
        }
        if (secretMappings != null) {
            this.secretMappings = new ArrayList();
            for (SecretMapping item : secretMappings) {
                this.addToSecretMappings(item);
            }
        } else {
            this.secretMappings = null;
        }
        return (A)this;
    }

    @Override
    public A withSecretMappings(SecretMapping ... secretMappings) {
        if (this.secretMappings != null) {
            this.secretMappings.clear();
        }
        if (secretMappings != null) {
            for (SecretMapping item : secretMappings) {
                this.addToSecretMappings(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretMappings() {
        return this.secretMappings != null && !this.secretMappings.isEmpty();
    }

    @Override
    public SelectorSyncSetSpecFluent.SecretMappingsNested<A> addNewSecretMapping() {
        return new SecretMappingsNestedImpl();
    }

    @Override
    public SelectorSyncSetSpecFluent.SecretMappingsNested<A> addNewSecretMappingLike(SecretMapping item) {
        return new SecretMappingsNestedImpl(-1, item);
    }

    @Override
    public SelectorSyncSetSpecFluent.SecretMappingsNested<A> setNewSecretMappingLike(Integer index, SecretMapping item) {
        return new SecretMappingsNestedImpl(index, item);
    }

    @Override
    public SelectorSyncSetSpecFluent.SecretMappingsNested<A> editSecretMapping(Integer index) {
        if (this.secretMappings.size() <= index) {
            throw new RuntimeException("Can't edit secretMappings. Index exceeds size.");
        }
        return this.setNewSecretMappingLike(index, this.buildSecretMapping(index));
    }

    @Override
    public SelectorSyncSetSpecFluent.SecretMappingsNested<A> editFirstSecretMapping() {
        if (this.secretMappings.size() == 0) {
            throw new RuntimeException("Can't edit first secretMappings. The list is empty.");
        }
        return this.setNewSecretMappingLike(0, this.buildSecretMapping(0));
    }

    @Override
    public SelectorSyncSetSpecFluent.SecretMappingsNested<A> editLastSecretMapping() {
        int index = this.secretMappings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secretMappings. The list is empty.");
        }
        return this.setNewSecretMappingLike(index, this.buildSecretMapping(index));
    }

    @Override
    public SelectorSyncSetSpecFluent.SecretMappingsNested<A> editMatchingSecretMapping(Predicate<SecretMappingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secretMappings.size(); ++i) {
            if (!predicate.test(this.secretMappings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secretMappings. No match found.");
        }
        return this.setNewSecretMappingLike(index, this.buildSecretMapping(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorSyncSetSpecFluentImpl that = (SelectorSyncSetSpecFluentImpl)o;
        if (this.applyBehavior != null ? !this.applyBehavior.equals(that.applyBehavior) : that.applyBehavior != null) {
            return false;
        }
        if (this.clusterDeploymentSelector != null ? !this.clusterDeploymentSelector.equals((Object)that.clusterDeploymentSelector) : that.clusterDeploymentSelector != null) {
            return false;
        }
        if (this.patches != null ? !this.patches.equals(that.patches) : that.patches != null) {
            return false;
        }
        if (this.resourceApplyMode != null ? !this.resourceApplyMode.equals(that.resourceApplyMode) : that.resourceApplyMode != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.secretMappings != null ? !this.secretMappings.equals(that.secretMappings) : that.secretMappings != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.applyBehavior, this.clusterDeploymentSelector, this.patches, this.resourceApplyMode, this.resources, this.secretMappings, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.applyBehavior != null) {
            sb.append("applyBehavior:");
            sb.append(this.applyBehavior + ",");
        }
        if (this.clusterDeploymentSelector != null) {
            sb.append("clusterDeploymentSelector:");
            sb.append(this.clusterDeploymentSelector + ",");
        }
        if (this.patches != null && !this.patches.isEmpty()) {
            sb.append("patches:");
            sb.append(this.patches + ",");
        }
        if (this.resourceApplyMode != null) {
            sb.append("resourceApplyMode:");
            sb.append(this.resourceApplyMode + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.secretMappings != null && !this.secretMappings.isEmpty()) {
            sb.append("secretMappings:");
            sb.append(this.secretMappings + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SecretMappingsNestedImpl<N>
    extends SecretMappingFluentImpl<SelectorSyncSetSpecFluent.SecretMappingsNested<N>>
    implements SelectorSyncSetSpecFluent.SecretMappingsNested<N>,
    Nested<N> {
        SecretMappingBuilder builder;
        Integer index;

        SecretMappingsNestedImpl(Integer index, SecretMapping item) {
            this.index = index;
            this.builder = new SecretMappingBuilder(this, item);
        }

        SecretMappingsNestedImpl() {
            this.index = -1;
            this.builder = new SecretMappingBuilder(this);
        }

        @Override
        public N and() {
            return (N)SelectorSyncSetSpecFluentImpl.this.setToSecretMappings(this.index, this.builder.build());
        }

        @Override
        public N endSecretMapping() {
            return this.and();
        }
    }

    class PatchesNestedImpl<N>
    extends SyncObjectPatchFluentImpl<SelectorSyncSetSpecFluent.PatchesNested<N>>
    implements SelectorSyncSetSpecFluent.PatchesNested<N>,
    Nested<N> {
        SyncObjectPatchBuilder builder;
        Integer index;

        PatchesNestedImpl(Integer index, SyncObjectPatch item) {
            this.index = index;
            this.builder = new SyncObjectPatchBuilder(this, item);
        }

        PatchesNestedImpl() {
            this.index = -1;
            this.builder = new SyncObjectPatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)SelectorSyncSetSpecFluentImpl.this.setToPatches(this.index, this.builder.build());
        }

        @Override
        public N endPatch() {
            return this.and();
        }
    }

    class ClusterDeploymentSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<SelectorSyncSetSpecFluent.ClusterDeploymentSelectorNested<N>>
    implements SelectorSyncSetSpecFluent.ClusterDeploymentSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        ClusterDeploymentSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        ClusterDeploymentSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)SelectorSyncSetSpecFluentImpl.this.withClusterDeploymentSelector(this.builder.build());
        }

        @Override
        public N endClusterDeploymentSelector() {
            return this.and();
        }
    }
}

