package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterRelocateSpecFluent<A extends ClusterRelocateSpecFluent<A>> extends BaseFluent<A>{
  public ClusterRelocateSpecFluent() {
  }
  
  public ClusterRelocateSpecFluent(ClusterRelocateSpec instance) {
    this.copyInstance(instance);
  }
  private LabelSelectorBuilder clusterDeploymentSelector;
  private KubeconfigSecretReferenceBuilder kubeconfigSecretRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterRelocateSpec instance) {
    instance = (instance != null ? instance : new ClusterRelocateSpec());
    if (instance != null) {
          this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
          this.withKubeconfigSecretRef(instance.getKubeconfigSecretRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public LabelSelector buildClusterDeploymentSelector() {
    return this.clusterDeploymentSelector != null ? this.clusterDeploymentSelector.build() : null;
  }
  
  public A withClusterDeploymentSelector(LabelSelector clusterDeploymentSelector) {
    this._visitables.remove("clusterDeploymentSelector");
    if (clusterDeploymentSelector != null) {
        this.clusterDeploymentSelector = new LabelSelectorBuilder(clusterDeploymentSelector);
        this._visitables.get("clusterDeploymentSelector").add(this.clusterDeploymentSelector);
    } else {
        this.clusterDeploymentSelector = null;
        this._visitables.get("clusterDeploymentSelector").remove(this.clusterDeploymentSelector);
    }
    return (A) this;
  }
  
  public boolean hasClusterDeploymentSelector() {
    return this.clusterDeploymentSelector != null;
  }
  
  public ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelector() {
    return new ClusterDeploymentSelectorNested(null);
  }
  
  public ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelectorLike(LabelSelector item) {
    return new ClusterDeploymentSelectorNested(item);
  }
  
  public ClusterDeploymentSelectorNested<A> editClusterDeploymentSelector() {
    return withNewClusterDeploymentSelectorLike(java.util.Optional.ofNullable(buildClusterDeploymentSelector()).orElse(null));
  }
  
  public ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelector() {
    return withNewClusterDeploymentSelectorLike(java.util.Optional.ofNullable(buildClusterDeploymentSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelectorLike(LabelSelector item) {
    return withNewClusterDeploymentSelectorLike(java.util.Optional.ofNullable(buildClusterDeploymentSelector()).orElse(item));
  }
  
  public KubeconfigSecretReference buildKubeconfigSecretRef() {
    return this.kubeconfigSecretRef != null ? this.kubeconfigSecretRef.build() : null;
  }
  
  public A withKubeconfigSecretRef(KubeconfigSecretReference kubeconfigSecretRef) {
    this._visitables.remove("kubeconfigSecretRef");
    if (kubeconfigSecretRef != null) {
        this.kubeconfigSecretRef = new KubeconfigSecretReferenceBuilder(kubeconfigSecretRef);
        this._visitables.get("kubeconfigSecretRef").add(this.kubeconfigSecretRef);
    } else {
        this.kubeconfigSecretRef = null;
        this._visitables.get("kubeconfigSecretRef").remove(this.kubeconfigSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasKubeconfigSecretRef() {
    return this.kubeconfigSecretRef != null;
  }
  
  public A withNewKubeconfigSecretRef(String name,String namespace) {
    return (A)withKubeconfigSecretRef(new KubeconfigSecretReference(name, namespace));
  }
  
  public KubeconfigSecretRefNested<A> withNewKubeconfigSecretRef() {
    return new KubeconfigSecretRefNested(null);
  }
  
  public KubeconfigSecretRefNested<A> withNewKubeconfigSecretRefLike(KubeconfigSecretReference item) {
    return new KubeconfigSecretRefNested(item);
  }
  
  public KubeconfigSecretRefNested<A> editKubeconfigSecretRef() {
    return withNewKubeconfigSecretRefLike(java.util.Optional.ofNullable(buildKubeconfigSecretRef()).orElse(null));
  }
  
  public KubeconfigSecretRefNested<A> editOrNewKubeconfigSecretRef() {
    return withNewKubeconfigSecretRefLike(java.util.Optional.ofNullable(buildKubeconfigSecretRef()).orElse(new KubeconfigSecretReferenceBuilder().build()));
  }
  
  public KubeconfigSecretRefNested<A> editOrNewKubeconfigSecretRefLike(KubeconfigSecretReference item) {
    return withNewKubeconfigSecretRefLike(java.util.Optional.ofNullable(buildKubeconfigSecretRef()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterRelocateSpecFluent that = (ClusterRelocateSpecFluent) o;
    if (!java.util.Objects.equals(clusterDeploymentSelector, that.clusterDeploymentSelector)) return false;
    if (!java.util.Objects.equals(kubeconfigSecretRef, that.kubeconfigSecretRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(clusterDeploymentSelector,  kubeconfigSecretRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterDeploymentSelector != null) { sb.append("clusterDeploymentSelector:"); sb.append(clusterDeploymentSelector + ","); }
    if (kubeconfigSecretRef != null) { sb.append("kubeconfigSecretRef:"); sb.append(kubeconfigSecretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClusterDeploymentSelectorNested<N> extends LabelSelectorFluent<ClusterDeploymentSelectorNested<N>> implements Nested<N>{
    ClusterDeploymentSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ClusterRelocateSpecFluent.this.withClusterDeploymentSelector(builder.build());
    }
    
    public N endClusterDeploymentSelector() {
      return and();
    }
    
  
  }
  public class KubeconfigSecretRefNested<N> extends KubeconfigSecretReferenceFluent<KubeconfigSecretRefNested<N>> implements Nested<N>{
    KubeconfigSecretRefNested(KubeconfigSecretReference item) {
      this.builder = new KubeconfigSecretReferenceBuilder(this, item);
    }
    KubeconfigSecretReferenceBuilder builder;
    
    public N and() {
      return (N) ClusterRelocateSpecFluent.this.withKubeconfigSecretRef(builder.build());
    }
    
    public N endKubeconfigSecretRef() {
      return and();
    }
    
  
  }

}