package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterStateBuilder extends ClusterStateFluent<ClusterStateBuilder> implements VisitableBuilder<ClusterState,ClusterStateBuilder>{
  public ClusterStateBuilder() {
    this(new ClusterState());
  }
  
  public ClusterStateBuilder(ClusterStateFluent<?> fluent) {
    this(fluent, new ClusterState());
  }
  
  public ClusterStateBuilder(ClusterStateFluent<?> fluent,ClusterState instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterStateBuilder(ClusterState instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterStateFluent<?> fluent;
  
  public ClusterState build() {
    ClusterState buildable = new ClusterState(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}