package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VeleroBackupConfigBuilder extends VeleroBackupConfigFluent<VeleroBackupConfigBuilder> implements VisitableBuilder<VeleroBackupConfig,VeleroBackupConfigBuilder>{
  public VeleroBackupConfigBuilder() {
    this(new VeleroBackupConfig());
  }
  
  public VeleroBackupConfigBuilder(VeleroBackupConfigFluent<?> fluent) {
    this(fluent, new VeleroBackupConfig());
  }
  
  public VeleroBackupConfigBuilder(VeleroBackupConfigFluent<?> fluent,VeleroBackupConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VeleroBackupConfigBuilder(VeleroBackupConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VeleroBackupConfigFluent<?> fluent;
  
  public VeleroBackupConfig build() {
    VeleroBackupConfig buildable = new VeleroBackupConfig(fluent.getEnabled(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}