package io.fabric8.openshift.api.model.hive.gcp.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OSDiskFluent<A extends OSDiskFluent<A>> extends BaseFluent<A>{
  public OSDiskFluent() {
  }
  
  public OSDiskFluent(OSDisk instance) {
    this.copyInstance(instance);
  }
  private Long diskSizeGB;
  private String diskType;
  private EncryptionKeyReferenceBuilder encryptionKey;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(OSDisk instance) {
    instance = (instance != null ? instance : new OSDisk());
    if (instance != null) {
          this.withDiskSizeGB(instance.getDiskSizeGB());
          this.withDiskType(instance.getDiskType());
          this.withEncryptionKey(instance.getEncryptionKey());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Long getDiskSizeGB() {
    return this.diskSizeGB;
  }
  
  public A withDiskSizeGB(Long diskSizeGB) {
    this.diskSizeGB = diskSizeGB;
    return (A) this;
  }
  
  public boolean hasDiskSizeGB() {
    return this.diskSizeGB != null;
  }
  
  public String getDiskType() {
    return this.diskType;
  }
  
  public A withDiskType(String diskType) {
    this.diskType = diskType;
    return (A) this;
  }
  
  public boolean hasDiskType() {
    return this.diskType != null;
  }
  
  public EncryptionKeyReference buildEncryptionKey() {
    return this.encryptionKey != null ? this.encryptionKey.build() : null;
  }
  
  public A withEncryptionKey(EncryptionKeyReference encryptionKey) {
    this._visitables.remove("encryptionKey");
    if (encryptionKey != null) {
        this.encryptionKey = new EncryptionKeyReferenceBuilder(encryptionKey);
        this._visitables.get("encryptionKey").add(this.encryptionKey);
    } else {
        this.encryptionKey = null;
        this._visitables.get("encryptionKey").remove(this.encryptionKey);
    }
    return (A) this;
  }
  
  public boolean hasEncryptionKey() {
    return this.encryptionKey != null;
  }
  
  public EncryptionKeyNested<A> withNewEncryptionKey() {
    return new EncryptionKeyNested(null);
  }
  
  public EncryptionKeyNested<A> withNewEncryptionKeyLike(EncryptionKeyReference item) {
    return new EncryptionKeyNested(item);
  }
  
  public EncryptionKeyNested<A> editEncryptionKey() {
    return withNewEncryptionKeyLike(java.util.Optional.ofNullable(buildEncryptionKey()).orElse(null));
  }
  
  public EncryptionKeyNested<A> editOrNewEncryptionKey() {
    return withNewEncryptionKeyLike(java.util.Optional.ofNullable(buildEncryptionKey()).orElse(new EncryptionKeyReferenceBuilder().build()));
  }
  
  public EncryptionKeyNested<A> editOrNewEncryptionKeyLike(EncryptionKeyReference item) {
    return withNewEncryptionKeyLike(java.util.Optional.ofNullable(buildEncryptionKey()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OSDiskFluent that = (OSDiskFluent) o;
    if (!java.util.Objects.equals(diskSizeGB, that.diskSizeGB)) return false;
    if (!java.util.Objects.equals(diskType, that.diskType)) return false;
    if (!java.util.Objects.equals(encryptionKey, that.encryptionKey)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(diskSizeGB,  diskType,  encryptionKey,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (diskSizeGB != null) { sb.append("diskSizeGB:"); sb.append(diskSizeGB + ","); }
    if (diskType != null) { sb.append("diskType:"); sb.append(diskType + ","); }
    if (encryptionKey != null) { sb.append("encryptionKey:"); sb.append(encryptionKey + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EncryptionKeyNested<N> extends EncryptionKeyReferenceFluent<EncryptionKeyNested<N>> implements Nested<N>{
    EncryptionKeyNested(EncryptionKeyReference item) {
      this.builder = new EncryptionKeyReferenceBuilder(this, item);
    }
    EncryptionKeyReferenceBuilder builder;
    
    public N and() {
      return (N) OSDiskFluent.this.withEncryptionKey(builder.build());
    }
    
    public N endEncryptionKey() {
      return and();
    }
    
  
  }

}