package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSClusterDeprovisionBuilder extends AWSClusterDeprovisionFluentImpl<AWSClusterDeprovisionBuilder> implements VisitableBuilder<AWSClusterDeprovision,AWSClusterDeprovisionBuilder>{
  public AWSClusterDeprovisionBuilder() {
    this(false);
  }
  public AWSClusterDeprovisionBuilder(Boolean validationEnabled) {
    this(new AWSClusterDeprovision(), validationEnabled);
  }
  public AWSClusterDeprovisionBuilder(AWSClusterDeprovisionFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSClusterDeprovisionBuilder(AWSClusterDeprovisionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSClusterDeprovision(), validationEnabled);
  }
  public AWSClusterDeprovisionBuilder(AWSClusterDeprovisionFluent<?> fluent,AWSClusterDeprovision instance) {
    this(fluent, instance, false);
  }
  public AWSClusterDeprovisionBuilder(AWSClusterDeprovisionFluent<?> fluent,AWSClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCredentialsAssumeRole(instance.getCredentialsAssumeRole()); 
    fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    fluent.withRegion(instance.getRegion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AWSClusterDeprovisionBuilder(AWSClusterDeprovision instance) {
    this(instance,false);
  }
  public AWSClusterDeprovisionBuilder(AWSClusterDeprovision instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole()); 
    this.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    this.withRegion(instance.getRegion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AWSClusterDeprovisionFluent<?> fluent;
  Boolean validationEnabled;
  public AWSClusterDeprovision build() {
    AWSClusterDeprovision buildable = new AWSClusterDeprovision(fluent.getCredentialsAssumeRole(),fluent.getCredentialsSecretRef(),fluent.getRegion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}