package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterRelocateSpecFluentImpl<A extends ClusterRelocateSpecFluent<A>> extends BaseFluent<A> implements ClusterRelocateSpecFluent<A>{
  public ClusterRelocateSpecFluentImpl() {
  }
  public ClusterRelocateSpecFluentImpl(ClusterRelocateSpec instance) {
    this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector()); 
    this.withKubeconfigSecretRef(instance.getKubeconfigSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private LabelSelectorBuilder clusterDeploymentSelector;
  private KubeconfigSecretReferenceBuilder kubeconfigSecretRef;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildClusterDeploymentSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getClusterDeploymentSelector() {
    return this.clusterDeploymentSelector!=null ?this.clusterDeploymentSelector.build():null;
  }
  public LabelSelector buildClusterDeploymentSelector() {
    return this.clusterDeploymentSelector!=null ?this.clusterDeploymentSelector.build():null;
  }
  public A withClusterDeploymentSelector(LabelSelector clusterDeploymentSelector) {
    _visitables.get("clusterDeploymentSelector").remove(this.clusterDeploymentSelector);
    if (clusterDeploymentSelector!=null){ this.clusterDeploymentSelector= new LabelSelectorBuilder(clusterDeploymentSelector); _visitables.get("clusterDeploymentSelector").add(this.clusterDeploymentSelector);} else { this.clusterDeploymentSelector = null; _visitables.get("clusterDeploymentSelector").remove(this.clusterDeploymentSelector); } return (A) this;
  }
  public Boolean hasClusterDeploymentSelector() {
    return this.clusterDeploymentSelector != null;
  }
  public ClusterRelocateSpecFluent.ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelector() {
    return new ClusterRelocateSpecFluentImpl.ClusterDeploymentSelectorNestedImpl();
  }
  public ClusterRelocateSpecFluent.ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelectorLike(LabelSelector item) {
    return new ClusterRelocateSpecFluentImpl.ClusterDeploymentSelectorNestedImpl(item);
  }
  public ClusterRelocateSpecFluent.ClusterDeploymentSelectorNested<A> editClusterDeploymentSelector() {
    return withNewClusterDeploymentSelectorLike(getClusterDeploymentSelector());
  }
  public ClusterRelocateSpecFluent.ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelector() {
    return withNewClusterDeploymentSelectorLike(getClusterDeploymentSelector() != null ? getClusterDeploymentSelector(): new LabelSelectorBuilder().build());
  }
  public ClusterRelocateSpecFluent.ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelectorLike(LabelSelector item) {
    return withNewClusterDeploymentSelectorLike(getClusterDeploymentSelector() != null ? getClusterDeploymentSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildKubeconfigSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public KubeconfigSecretReference getKubeconfigSecretRef() {
    return this.kubeconfigSecretRef!=null ?this.kubeconfigSecretRef.build():null;
  }
  public KubeconfigSecretReference buildKubeconfigSecretRef() {
    return this.kubeconfigSecretRef!=null ?this.kubeconfigSecretRef.build():null;
  }
  public A withKubeconfigSecretRef(KubeconfigSecretReference kubeconfigSecretRef) {
    _visitables.get("kubeconfigSecretRef").remove(this.kubeconfigSecretRef);
    if (kubeconfigSecretRef!=null){ this.kubeconfigSecretRef= new KubeconfigSecretReferenceBuilder(kubeconfigSecretRef); _visitables.get("kubeconfigSecretRef").add(this.kubeconfigSecretRef);} else { this.kubeconfigSecretRef = null; _visitables.get("kubeconfigSecretRef").remove(this.kubeconfigSecretRef); } return (A) this;
  }
  public Boolean hasKubeconfigSecretRef() {
    return this.kubeconfigSecretRef != null;
  }
  public A withNewKubeconfigSecretRef(String name,String namespace) {
    return (A)withKubeconfigSecretRef(new KubeconfigSecretReference(name, namespace));
  }
  public ClusterRelocateSpecFluent.KubeconfigSecretRefNested<A> withNewKubeconfigSecretRef() {
    return new ClusterRelocateSpecFluentImpl.KubeconfigSecretRefNestedImpl();
  }
  public ClusterRelocateSpecFluent.KubeconfigSecretRefNested<A> withNewKubeconfigSecretRefLike(KubeconfigSecretReference item) {
    return new ClusterRelocateSpecFluentImpl.KubeconfigSecretRefNestedImpl(item);
  }
  public ClusterRelocateSpecFluent.KubeconfigSecretRefNested<A> editKubeconfigSecretRef() {
    return withNewKubeconfigSecretRefLike(getKubeconfigSecretRef());
  }
  public ClusterRelocateSpecFluent.KubeconfigSecretRefNested<A> editOrNewKubeconfigSecretRef() {
    return withNewKubeconfigSecretRefLike(getKubeconfigSecretRef() != null ? getKubeconfigSecretRef(): new KubeconfigSecretReferenceBuilder().build());
  }
  public ClusterRelocateSpecFluent.KubeconfigSecretRefNested<A> editOrNewKubeconfigSecretRefLike(KubeconfigSecretReference item) {
    return withNewKubeconfigSecretRefLike(getKubeconfigSecretRef() != null ? getKubeconfigSecretRef(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterRelocateSpecFluentImpl that = (ClusterRelocateSpecFluentImpl) o;
    if (clusterDeploymentSelector != null ? !clusterDeploymentSelector.equals(that.clusterDeploymentSelector) :that.clusterDeploymentSelector != null) return false;
    if (kubeconfigSecretRef != null ? !kubeconfigSecretRef.equals(that.kubeconfigSecretRef) :that.kubeconfigSecretRef != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterDeploymentSelector,  kubeconfigSecretRef,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterDeploymentSelector != null) { sb.append("clusterDeploymentSelector:"); sb.append(clusterDeploymentSelector + ","); }
    if (kubeconfigSecretRef != null) { sb.append("kubeconfigSecretRef:"); sb.append(kubeconfigSecretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClusterDeploymentSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ClusterRelocateSpecFluent.ClusterDeploymentSelectorNested<N>> implements ClusterRelocateSpecFluent.ClusterDeploymentSelectorNested<N>,Nested<N>{
    ClusterDeploymentSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    ClusterDeploymentSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ClusterRelocateSpecFluentImpl.this.withClusterDeploymentSelector(builder.build());
    }
    public N endClusterDeploymentSelector() {
      return and();
    }
    
  }
  class KubeconfigSecretRefNestedImpl<N> extends KubeconfigSecretReferenceFluentImpl<ClusterRelocateSpecFluent.KubeconfigSecretRefNested<N>> implements ClusterRelocateSpecFluent.KubeconfigSecretRefNested<N>,Nested<N>{
    KubeconfigSecretRefNestedImpl(KubeconfigSecretReference item) {
      this.builder = new KubeconfigSecretReferenceBuilder(this, item);
    }
    KubeconfigSecretRefNestedImpl() {
      this.builder = new KubeconfigSecretReferenceBuilder(this);
    }
    KubeconfigSecretReferenceBuilder builder;
    public N and() {
      return (N) ClusterRelocateSpecFluentImpl.this.withKubeconfigSecretRef(builder.build());
    }
    public N endKubeconfigSecretRef() {
      return and();
    }
    
  }
  
}