package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolNameLeaseStatusBuilder extends MachinePoolNameLeaseStatusFluentImpl<MachinePoolNameLeaseStatusBuilder> implements VisitableBuilder<MachinePoolNameLeaseStatus,MachinePoolNameLeaseStatusBuilder>{
  public MachinePoolNameLeaseStatusBuilder() {
    this(false);
  }
  public MachinePoolNameLeaseStatusBuilder(Boolean validationEnabled) {
    this(new MachinePoolNameLeaseStatus(), validationEnabled);
  }
  public MachinePoolNameLeaseStatusBuilder(MachinePoolNameLeaseStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolNameLeaseStatusBuilder(MachinePoolNameLeaseStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolNameLeaseStatus(), validationEnabled);
  }
  public MachinePoolNameLeaseStatusBuilder(MachinePoolNameLeaseStatusFluent<?> fluent,MachinePoolNameLeaseStatus instance) {
    this(fluent, instance, false);
  }
  public MachinePoolNameLeaseStatusBuilder(MachinePoolNameLeaseStatusFluent<?> fluent,MachinePoolNameLeaseStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolNameLeaseStatusBuilder(MachinePoolNameLeaseStatus instance) {
    this(instance,false);
  }
  public MachinePoolNameLeaseStatusBuilder(MachinePoolNameLeaseStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MachinePoolNameLeaseStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolNameLeaseStatus build() {
    MachinePoolNameLeaseStatus buildable = new MachinePoolNameLeaseStatus();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}