package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SpotMarketOptionsBuilder extends SpotMarketOptionsFluentImpl<SpotMarketOptionsBuilder> implements VisitableBuilder<SpotMarketOptions,SpotMarketOptionsBuilder>{
  public SpotMarketOptionsBuilder() {
    this(false);
  }
  public SpotMarketOptionsBuilder(Boolean validationEnabled) {
    this(new SpotMarketOptions(), validationEnabled);
  }
  public SpotMarketOptionsBuilder(SpotMarketOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public SpotMarketOptionsBuilder(SpotMarketOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SpotMarketOptions(), validationEnabled);
  }
  public SpotMarketOptionsBuilder(SpotMarketOptionsFluent<?> fluent,SpotMarketOptions instance) {
    this(fluent, instance, false);
  }
  public SpotMarketOptionsBuilder(SpotMarketOptionsFluent<?> fluent,SpotMarketOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMaxPrice(instance.getMaxPrice()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SpotMarketOptionsBuilder(SpotMarketOptions instance) {
    this(instance,false);
  }
  public SpotMarketOptionsBuilder(SpotMarketOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMaxPrice(instance.getMaxPrice()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SpotMarketOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public SpotMarketOptions build() {
    SpotMarketOptions buildable = new SpotMarketOptions(fluent.getMaxPrice());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}