package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AWSPrivateLinkInventoryBuilder extends AWSPrivateLinkInventoryFluentImpl<AWSPrivateLinkInventoryBuilder> implements VisitableBuilder<AWSPrivateLinkInventory,AWSPrivateLinkInventoryBuilder>{
  public AWSPrivateLinkInventoryBuilder() {
    this(false);
  }
  public AWSPrivateLinkInventoryBuilder(Boolean validationEnabled) {
    this(new AWSPrivateLinkInventory(), validationEnabled);
  }
  public AWSPrivateLinkInventoryBuilder(AWSPrivateLinkInventoryFluent<?> fluent) {
    this(fluent, false);
  }
  public AWSPrivateLinkInventoryBuilder(AWSPrivateLinkInventoryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AWSPrivateLinkInventory(), validationEnabled);
  }
  public AWSPrivateLinkInventoryBuilder(AWSPrivateLinkInventoryFluent<?> fluent,AWSPrivateLinkInventory instance) {
    this(fluent, instance, false);
  }
  public AWSPrivateLinkInventoryBuilder(AWSPrivateLinkInventoryFluent<?> fluent,AWSPrivateLinkInventory instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRegion(instance.getRegion()); 
    fluent.withSubnets(instance.getSubnets()); 
    fluent.withVpcID(instance.getVpcID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public AWSPrivateLinkInventoryBuilder(AWSPrivateLinkInventory instance) {
    this(instance,false);
  }
  public AWSPrivateLinkInventoryBuilder(AWSPrivateLinkInventory instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRegion(instance.getRegion()); 
    this.withSubnets(instance.getSubnets()); 
    this.withVpcID(instance.getVpcID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  AWSPrivateLinkInventoryFluent<?> fluent;
  Boolean validationEnabled;
  public AWSPrivateLinkInventory build() {
    AWSPrivateLinkInventory buildable = new AWSPrivateLinkInventory(fluent.getRegion(),fluent.getSubnets(),fluent.getVpcID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}