package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GCPDNSZoneStatusBuilder extends GCPDNSZoneStatusFluentImpl<GCPDNSZoneStatusBuilder> implements VisitableBuilder<GCPDNSZoneStatus,GCPDNSZoneStatusBuilder>{
  public GCPDNSZoneStatusBuilder() {
    this(false);
  }
  public GCPDNSZoneStatusBuilder(Boolean validationEnabled) {
    this(new GCPDNSZoneStatus(), validationEnabled);
  }
  public GCPDNSZoneStatusBuilder(GCPDNSZoneStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public GCPDNSZoneStatusBuilder(GCPDNSZoneStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GCPDNSZoneStatus(), validationEnabled);
  }
  public GCPDNSZoneStatusBuilder(GCPDNSZoneStatusFluent<?> fluent,GCPDNSZoneStatus instance) {
    this(fluent, instance, false);
  }
  public GCPDNSZoneStatusBuilder(GCPDNSZoneStatusFluent<?> fluent,GCPDNSZoneStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withZoneName(instance.getZoneName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GCPDNSZoneStatusBuilder(GCPDNSZoneStatus instance) {
    this(instance,false);
  }
  public GCPDNSZoneStatusBuilder(GCPDNSZoneStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withZoneName(instance.getZoneName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GCPDNSZoneStatusFluent<?> fluent;
  Boolean validationEnabled;
  public GCPDNSZoneStatus build() {
    GCPDNSZoneStatus buildable = new GCPDNSZoneStatus(fluent.getZoneName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}