package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ManageDNSConfigFluentImpl<A extends ManageDNSConfigFluent<A>> extends BaseFluent<A> implements ManageDNSConfigFluent<A>{
  public ManageDNSConfigFluentImpl() {
  }
  public ManageDNSConfigFluentImpl(ManageDNSConfig instance) {
    this.withAws(instance.getAws()); 
    this.withAzure(instance.getAzure()); 
    this.withDomains(instance.getDomains()); 
    this.withGcp(instance.getGcp()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ManageDNSAWSConfigBuilder aws;
  private ManageDNSAzureConfigBuilder azure;
  private List<String> domains = new ArrayList<String>();
  private ManageDNSGCPConfigBuilder gcp;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAws instead.
   * @return The buildable object.
   */
  @Deprecated
  public ManageDNSAWSConfig getAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public ManageDNSAWSConfig buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public A withAws(ManageDNSAWSConfig aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new ManageDNSAWSConfigBuilder(aws); _visitables.get("aws").add(this.aws);} else { this.aws = null; _visitables.get("aws").remove(this.aws); } return (A) this;
  }
  public Boolean hasAws() {
    return this.aws != null;
  }
  public ManageDNSConfigFluent.AwsNested<A> withNewAws() {
    return new ManageDNSConfigFluentImpl.AwsNestedImpl();
  }
  public ManageDNSConfigFluent.AwsNested<A> withNewAwsLike(ManageDNSAWSConfig item) {
    return new ManageDNSConfigFluentImpl.AwsNestedImpl(item);
  }
  public ManageDNSConfigFluent.AwsNested<A> editAws() {
    return withNewAwsLike(getAws());
  }
  public ManageDNSConfigFluent.AwsNested<A> editOrNewAws() {
    return withNewAwsLike(getAws() != null ? getAws(): new ManageDNSAWSConfigBuilder().build());
  }
  public ManageDNSConfigFluent.AwsNested<A> editOrNewAwsLike(ManageDNSAWSConfig item) {
    return withNewAwsLike(getAws() != null ? getAws(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAzure instead.
   * @return The buildable object.
   */
  @Deprecated
  public ManageDNSAzureConfig getAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public ManageDNSAzureConfig buildAzure() {
    return this.azure!=null ?this.azure.build():null;
  }
  public A withAzure(ManageDNSAzureConfig azure) {
    _visitables.get("azure").remove(this.azure);
    if (azure!=null){ this.azure= new ManageDNSAzureConfigBuilder(azure); _visitables.get("azure").add(this.azure);} else { this.azure = null; _visitables.get("azure").remove(this.azure); } return (A) this;
  }
  public Boolean hasAzure() {
    return this.azure != null;
  }
  public ManageDNSConfigFluent.AzureNested<A> withNewAzure() {
    return new ManageDNSConfigFluentImpl.AzureNestedImpl();
  }
  public ManageDNSConfigFluent.AzureNested<A> withNewAzureLike(ManageDNSAzureConfig item) {
    return new ManageDNSConfigFluentImpl.AzureNestedImpl(item);
  }
  public ManageDNSConfigFluent.AzureNested<A> editAzure() {
    return withNewAzureLike(getAzure());
  }
  public ManageDNSConfigFluent.AzureNested<A> editOrNewAzure() {
    return withNewAzureLike(getAzure() != null ? getAzure(): new ManageDNSAzureConfigBuilder().build());
  }
  public ManageDNSConfigFluent.AzureNested<A> editOrNewAzureLike(ManageDNSAzureConfig item) {
    return withNewAzureLike(getAzure() != null ? getAzure(): item);
  }
  public A addToDomains(Integer index,String item) {
    if (this.domains == null) {this.domains = new ArrayList<String>();}
    this.domains.add(index, item);
    return (A)this;
  }
  public A setToDomains(Integer index,String item) {
    if (this.domains == null) {this.domains = new ArrayList<String>();}
    this.domains.set(index, item); return (A)this;
  }
  public A addToDomains(java.lang.String... items) {
    if (this.domains == null) {this.domains = new ArrayList<String>();}
    for (String item : items) {this.domains.add(item);} return (A)this;
  }
  public A addAllToDomains(Collection<String> items) {
    if (this.domains == null) {this.domains = new ArrayList<String>();}
    for (String item : items) {this.domains.add(item);} return (A)this;
  }
  public A removeFromDomains(java.lang.String... items) {
    for (String item : items) {if (this.domains!= null){ this.domains.remove(item);}} return (A)this;
  }
  public A removeAllFromDomains(Collection<String> items) {
    for (String item : items) {if (this.domains!= null){ this.domains.remove(item);}} return (A)this;
  }
  public List<String> getDomains() {
    return this.domains;
  }
  public String getDomain(Integer index) {
    return this.domains.get(index);
  }
  public String getFirstDomain() {
    return this.domains.get(0);
  }
  public String getLastDomain() {
    return this.domains.get(domains.size() - 1);
  }
  public String getMatchingDomain(Predicate<String> predicate) {
    for (String item: domains) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDomain(Predicate<String> predicate) {
    for (String item: domains) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDomains(List<String> domains) {
    if (domains != null) {this.domains = new ArrayList(); for (String item : domains){this.addToDomains(item);}} else { this.domains = null;} return (A) this;
  }
  public A withDomains(java.lang.String... domains) {
    if (this.domains != null) {this.domains.clear();}
    if (domains != null) {for (String item :domains){ this.addToDomains(item);}} return (A) this;
  }
  public Boolean hasDomains() {
    return domains != null && !domains.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildGcp instead.
   * @return The buildable object.
   */
  @Deprecated
  public ManageDNSGCPConfig getGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public ManageDNSGCPConfig buildGcp() {
    return this.gcp!=null ?this.gcp.build():null;
  }
  public A withGcp(ManageDNSGCPConfig gcp) {
    _visitables.get("gcp").remove(this.gcp);
    if (gcp!=null){ this.gcp= new ManageDNSGCPConfigBuilder(gcp); _visitables.get("gcp").add(this.gcp);} else { this.gcp = null; _visitables.get("gcp").remove(this.gcp); } return (A) this;
  }
  public Boolean hasGcp() {
    return this.gcp != null;
  }
  public ManageDNSConfigFluent.GcpNested<A> withNewGcp() {
    return new ManageDNSConfigFluentImpl.GcpNestedImpl();
  }
  public ManageDNSConfigFluent.GcpNested<A> withNewGcpLike(ManageDNSGCPConfig item) {
    return new ManageDNSConfigFluentImpl.GcpNestedImpl(item);
  }
  public ManageDNSConfigFluent.GcpNested<A> editGcp() {
    return withNewGcpLike(getGcp());
  }
  public ManageDNSConfigFluent.GcpNested<A> editOrNewGcp() {
    return withNewGcpLike(getGcp() != null ? getGcp(): new ManageDNSGCPConfigBuilder().build());
  }
  public ManageDNSConfigFluent.GcpNested<A> editOrNewGcpLike(ManageDNSGCPConfig item) {
    return withNewGcpLike(getGcp() != null ? getGcp(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ManageDNSConfigFluentImpl that = (ManageDNSConfigFluentImpl) o;
    if (aws != null ? !aws.equals(that.aws) :that.aws != null) return false;
    if (azure != null ? !azure.equals(that.azure) :that.azure != null) return false;
    if (domains != null ? !domains.equals(that.domains) :that.domains != null) return false;
    if (gcp != null ? !gcp.equals(that.gcp) :that.gcp != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(aws,  azure,  domains,  gcp,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (azure != null) { sb.append("azure:"); sb.append(azure + ","); }
    if (domains != null && !domains.isEmpty()) { sb.append("domains:"); sb.append(domains + ","); }
    if (gcp != null) { sb.append("gcp:"); sb.append(gcp + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AwsNestedImpl<N> extends ManageDNSAWSConfigFluentImpl<ManageDNSConfigFluent.AwsNested<N>> implements ManageDNSConfigFluent.AwsNested<N>,Nested<N>{
    AwsNestedImpl(ManageDNSAWSConfig item) {
      this.builder = new ManageDNSAWSConfigBuilder(this, item);
    }
    AwsNestedImpl() {
      this.builder = new ManageDNSAWSConfigBuilder(this);
    }
    ManageDNSAWSConfigBuilder builder;
    public N and() {
      return (N) ManageDNSConfigFluentImpl.this.withAws(builder.build());
    }
    public N endAws() {
      return and();
    }
    
  }
  class AzureNestedImpl<N> extends ManageDNSAzureConfigFluentImpl<ManageDNSConfigFluent.AzureNested<N>> implements ManageDNSConfigFluent.AzureNested<N>,Nested<N>{
    AzureNestedImpl(ManageDNSAzureConfig item) {
      this.builder = new ManageDNSAzureConfigBuilder(this, item);
    }
    AzureNestedImpl() {
      this.builder = new ManageDNSAzureConfigBuilder(this);
    }
    ManageDNSAzureConfigBuilder builder;
    public N and() {
      return (N) ManageDNSConfigFluentImpl.this.withAzure(builder.build());
    }
    public N endAzure() {
      return and();
    }
    
  }
  class GcpNestedImpl<N> extends ManageDNSGCPConfigFluentImpl<ManageDNSConfigFluent.GcpNested<N>> implements ManageDNSConfigFluent.GcpNested<N>,Nested<N>{
    GcpNestedImpl(ManageDNSGCPConfig item) {
      this.builder = new ManageDNSGCPConfigBuilder(this, item);
    }
    GcpNestedImpl() {
      this.builder = new ManageDNSGCPConfigBuilder(this);
    }
    ManageDNSGCPConfigBuilder builder;
    public N and() {
      return (N) ManageDNSConfigFluentImpl.this.withGcp(builder.build());
    }
    public N endGcp() {
      return and();
    }
    
  }
  
}