package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EC2RootVolumeBuilder extends EC2RootVolumeFluentImpl<EC2RootVolumeBuilder> implements VisitableBuilder<EC2RootVolume,EC2RootVolumeBuilder>{
  public EC2RootVolumeBuilder() {
    this(false);
  }
  public EC2RootVolumeBuilder(Boolean validationEnabled) {
    this(new EC2RootVolume(), validationEnabled);
  }
  public EC2RootVolumeBuilder(EC2RootVolumeFluent<?> fluent) {
    this(fluent, false);
  }
  public EC2RootVolumeBuilder(EC2RootVolumeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EC2RootVolume(), validationEnabled);
  }
  public EC2RootVolumeBuilder(EC2RootVolumeFluent<?> fluent,EC2RootVolume instance) {
    this(fluent, instance, false);
  }
  public EC2RootVolumeBuilder(EC2RootVolumeFluent<?> fluent,EC2RootVolume instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIops(instance.getIops()); 
    fluent.withKmsKeyARN(instance.getKmsKeyARN()); 
    fluent.withSize(instance.getSize()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EC2RootVolumeBuilder(EC2RootVolume instance) {
    this(instance,false);
  }
  public EC2RootVolumeBuilder(EC2RootVolume instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withIops(instance.getIops()); 
    this.withKmsKeyARN(instance.getKmsKeyARN()); 
    this.withSize(instance.getSize()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  EC2RootVolumeFluent<?> fluent;
  Boolean validationEnabled;
  public EC2RootVolume build() {
    EC2RootVolume buildable = new EC2RootVolume(fluent.getIops(),fluent.getKmsKeyARN(),fluent.getSize(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}