package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BackupConfigBuilder extends BackupConfigFluentImpl<BackupConfigBuilder> implements VisitableBuilder<BackupConfig,BackupConfigBuilder>{
  public BackupConfigBuilder() {
    this(false);
  }
  public BackupConfigBuilder(Boolean validationEnabled) {
    this(new BackupConfig(), validationEnabled);
  }
  public BackupConfigBuilder(BackupConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public BackupConfigBuilder(BackupConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new BackupConfig(), validationEnabled);
  }
  public BackupConfigBuilder(BackupConfigFluent<?> fluent,BackupConfig instance) {
    this(fluent, instance, false);
  }
  public BackupConfigBuilder(BackupConfigFluent<?> fluent,BackupConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds()); 
    fluent.withVelero(instance.getVelero()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public BackupConfigBuilder(BackupConfig instance) {
    this(instance,false);
  }
  public BackupConfigBuilder(BackupConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds()); 
    this.withVelero(instance.getVelero()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  BackupConfigFluent<?> fluent;
  Boolean validationEnabled;
  public BackupConfig build() {
    BackupConfig buildable = new BackupConfig(fluent.getMinBackupPeriodSeconds(),fluent.getVelero());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}