package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateBundleStatusBuilder extends CertificateBundleStatusFluentImpl<CertificateBundleStatusBuilder> implements VisitableBuilder<CertificateBundleStatus,CertificateBundleStatusBuilder>{
  public CertificateBundleStatusBuilder() {
    this(false);
  }
  public CertificateBundleStatusBuilder(Boolean validationEnabled) {
    this(new CertificateBundleStatus(), validationEnabled);
  }
  public CertificateBundleStatusBuilder(CertificateBundleStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateBundleStatusBuilder(CertificateBundleStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateBundleStatus(), validationEnabled);
  }
  public CertificateBundleStatusBuilder(CertificateBundleStatusFluent<?> fluent,CertificateBundleStatus instance) {
    this(fluent, instance, false);
  }
  public CertificateBundleStatusBuilder(CertificateBundleStatusFluent<?> fluent,CertificateBundleStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGenerated(instance.getGenerated()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CertificateBundleStatusBuilder(CertificateBundleStatus instance) {
    this(instance,false);
  }
  public CertificateBundleStatusBuilder(CertificateBundleStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGenerated(instance.getGenerated()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CertificateBundleStatusFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateBundleStatus build() {
    CertificateBundleStatus buildable = new CertificateBundleStatus(fluent.getGenerated(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}