package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterDeploymentSpecFluentImpl<A extends ClusterDeploymentSpecFluent<A>> extends BaseFluent<A> implements ClusterDeploymentSpecFluent<A>{
  public ClusterDeploymentSpecFluentImpl() {
  }
  public ClusterDeploymentSpecFluentImpl(ClusterDeploymentSpec instance) {
    this.withBaseDomain(instance.getBaseDomain()); 
    this.withBoundServiceAccountSigningKeySecretRef(instance.getBoundServiceAccountSigningKeySecretRef()); 
    this.withCertificateBundles(instance.getCertificateBundles()); 
    this.withClusterInstallRef(instance.getClusterInstallRef()); 
    this.withClusterMetadata(instance.getClusterMetadata()); 
    this.withClusterName(instance.getClusterName()); 
    this.withClusterPoolRef(instance.getClusterPoolRef()); 
    this.withControlPlaneConfig(instance.getControlPlaneConfig()); 
    this.withHibernateAfter(instance.getHibernateAfter()); 
    this.withIngress(instance.getIngress()); 
    this.withInstallAttemptsLimit(instance.getInstallAttemptsLimit()); 
    this.withInstalled(instance.getInstalled()); 
    this.withManageDNS(instance.getManageDNS()); 
    this.withPlatform(instance.getPlatform()); 
    this.withPowerState(instance.getPowerState()); 
    this.withPreserveOnDelete(instance.getPreserveOnDelete()); 
    this.withProvisioning(instance.getProvisioning()); 
    this.withPullSecretRef(instance.getPullSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String baseDomain;
  private LocalObjectReferenceBuilder boundServiceAccountSigningKeySecretRef;
  private ArrayList<CertificateBundleSpecBuilder> certificateBundles = new ArrayList<CertificateBundleSpecBuilder>();
  private ClusterInstallLocalReferenceBuilder clusterInstallRef;
  private ClusterMetadataBuilder clusterMetadata;
  private String clusterName;
  private ClusterPoolReferenceBuilder clusterPoolRef;
  private ControlPlaneConfigSpecBuilder controlPlaneConfig;
  private Duration hibernateAfter;
  private ArrayList<ClusterIngressBuilder> ingress = new ArrayList<ClusterIngressBuilder>();
  private Integer installAttemptsLimit;
  private Boolean installed;
  private Boolean manageDNS;
  private PlatformBuilder platform;
  private String powerState;
  private Boolean preserveOnDelete;
  private ProvisioningBuilder provisioning;
  private LocalObjectReferenceBuilder pullSecretRef;
  private Map<String,Object> additionalProperties;
  public String getBaseDomain() {
    return this.baseDomain;
  }
  public A withBaseDomain(String baseDomain) {
    this.baseDomain=baseDomain; return (A) this;
  }
  public Boolean hasBaseDomain() {
    return this.baseDomain != null;
  }
  
  /**
   * This method has been deprecated, please use method buildBoundServiceAccountSigningKeySecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getBoundServiceAccountSigningKeySecretRef() {
    return this.boundServiceAccountSigningKeySecretRef!=null ?this.boundServiceAccountSigningKeySecretRef.build():null;
  }
  public LocalObjectReference buildBoundServiceAccountSigningKeySecretRef() {
    return this.boundServiceAccountSigningKeySecretRef!=null ?this.boundServiceAccountSigningKeySecretRef.build():null;
  }
  public A withBoundServiceAccountSigningKeySecretRef(LocalObjectReference boundServiceAccountSigningKeySecretRef) {
    _visitables.get("boundServiceAccountSigningKeySecretRef").remove(this.boundServiceAccountSigningKeySecretRef);
    if (boundServiceAccountSigningKeySecretRef!=null){ this.boundServiceAccountSigningKeySecretRef= new LocalObjectReferenceBuilder(boundServiceAccountSigningKeySecretRef); _visitables.get("boundServiceAccountSigningKeySecretRef").add(this.boundServiceAccountSigningKeySecretRef);} else { this.boundServiceAccountSigningKeySecretRef = null; _visitables.get("boundServiceAccountSigningKeySecretRef").remove(this.boundServiceAccountSigningKeySecretRef); } return (A) this;
  }
  public Boolean hasBoundServiceAccountSigningKeySecretRef() {
    return this.boundServiceAccountSigningKeySecretRef != null;
  }
  public A withNewBoundServiceAccountSigningKeySecretRef(String name) {
    return (A)withBoundServiceAccountSigningKeySecretRef(new LocalObjectReference(name));
  }
  public ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<A> withNewBoundServiceAccountSigningKeySecretRef() {
    return new ClusterDeploymentSpecFluentImpl.BoundServiceAccountSigningKeySecretRefNestedImpl();
  }
  public ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<A> withNewBoundServiceAccountSigningKeySecretRefLike(LocalObjectReference item) {
    return new ClusterDeploymentSpecFluentImpl.BoundServiceAccountSigningKeySecretRefNestedImpl(item);
  }
  public ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<A> editBoundServiceAccountSigningKeySecretRef() {
    return withNewBoundServiceAccountSigningKeySecretRefLike(getBoundServiceAccountSigningKeySecretRef());
  }
  public ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<A> editOrNewBoundServiceAccountSigningKeySecretRef() {
    return withNewBoundServiceAccountSigningKeySecretRefLike(getBoundServiceAccountSigningKeySecretRef() != null ? getBoundServiceAccountSigningKeySecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<A> editOrNewBoundServiceAccountSigningKeySecretRefLike(LocalObjectReference item) {
    return withNewBoundServiceAccountSigningKeySecretRefLike(getBoundServiceAccountSigningKeySecretRef() != null ? getBoundServiceAccountSigningKeySecretRef(): item);
  }
  public A addToCertificateBundles(Integer index,CertificateBundleSpec item) {
    if (this.certificateBundles == null) {this.certificateBundles = new ArrayList<CertificateBundleSpecBuilder>();}
    CertificateBundleSpecBuilder builder = new CertificateBundleSpecBuilder(item);_visitables.get("certificateBundles").add(index >= 0 ? index : _visitables.get("certificateBundles").size(), builder);this.certificateBundles.add(index >= 0 ? index : certificateBundles.size(), builder); return (A)this;
  }
  public A setToCertificateBundles(Integer index,CertificateBundleSpec item) {
    if (this.certificateBundles == null) {this.certificateBundles = new ArrayList<CertificateBundleSpecBuilder>();}
    CertificateBundleSpecBuilder builder = new CertificateBundleSpecBuilder(item);
    if (index < 0 || index >= _visitables.get("certificateBundles").size()) { _visitables.get("certificateBundles").add(builder); } else { _visitables.get("certificateBundles").set(index, builder);}
    if (index < 0 || index >= certificateBundles.size()) { certificateBundles.add(builder); } else { certificateBundles.set(index, builder);}
     return (A)this;
  }
  public A addToCertificateBundles(io.fabric8.openshift.api.model.hive.v1.CertificateBundleSpec... items) {
    if (this.certificateBundles == null) {this.certificateBundles = new ArrayList<CertificateBundleSpecBuilder>();}
    for (CertificateBundleSpec item : items) {CertificateBundleSpecBuilder builder = new CertificateBundleSpecBuilder(item);_visitables.get("certificateBundles").add(builder);this.certificateBundles.add(builder);} return (A)this;
  }
  public A addAllToCertificateBundles(Collection<CertificateBundleSpec> items) {
    if (this.certificateBundles == null) {this.certificateBundles = new ArrayList<CertificateBundleSpecBuilder>();}
    for (CertificateBundleSpec item : items) {CertificateBundleSpecBuilder builder = new CertificateBundleSpecBuilder(item);_visitables.get("certificateBundles").add(builder);this.certificateBundles.add(builder);} return (A)this;
  }
  public A removeFromCertificateBundles(io.fabric8.openshift.api.model.hive.v1.CertificateBundleSpec... items) {
    for (CertificateBundleSpec item : items) {CertificateBundleSpecBuilder builder = new CertificateBundleSpecBuilder(item);_visitables.get("certificateBundles").remove(builder);if (this.certificateBundles != null) {this.certificateBundles.remove(builder);}} return (A)this;
  }
  public A removeAllFromCertificateBundles(Collection<CertificateBundleSpec> items) {
    for (CertificateBundleSpec item : items) {CertificateBundleSpecBuilder builder = new CertificateBundleSpecBuilder(item);_visitables.get("certificateBundles").remove(builder);if (this.certificateBundles != null) {this.certificateBundles.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromCertificateBundles(Predicate<CertificateBundleSpecBuilder> predicate) {
    if (certificateBundles == null) return (A) this;
    final Iterator<CertificateBundleSpecBuilder> each = certificateBundles.iterator();
    final List visitables = _visitables.get("certificateBundles");
    while (each.hasNext()) {
      CertificateBundleSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildCertificateBundles instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CertificateBundleSpec> getCertificateBundles() {
    return certificateBundles != null ? build(certificateBundles) : null;
  }
  public List<CertificateBundleSpec> buildCertificateBundles() {
    return certificateBundles != null ? build(certificateBundles) : null;
  }
  public CertificateBundleSpec buildCertificateBundle(Integer index) {
    return this.certificateBundles.get(index).build();
  }
  public CertificateBundleSpec buildFirstCertificateBundle() {
    return this.certificateBundles.get(0).build();
  }
  public CertificateBundleSpec buildLastCertificateBundle() {
    return this.certificateBundles.get(certificateBundles.size() - 1).build();
  }
  public CertificateBundleSpec buildMatchingCertificateBundle(Predicate<CertificateBundleSpecBuilder> predicate) {
    for (CertificateBundleSpecBuilder item: certificateBundles) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCertificateBundle(Predicate<CertificateBundleSpecBuilder> predicate) {
    for (CertificateBundleSpecBuilder item: certificateBundles) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCertificateBundles(List<CertificateBundleSpec> certificateBundles) {
    if (this.certificateBundles != null) { _visitables.get("certificateBundles").removeAll(this.certificateBundles);}
    if (certificateBundles != null) {this.certificateBundles = new ArrayList(); for (CertificateBundleSpec item : certificateBundles){this.addToCertificateBundles(item);}} else { this.certificateBundles = null;} return (A) this;
  }
  public A withCertificateBundles(io.fabric8.openshift.api.model.hive.v1.CertificateBundleSpec... certificateBundles) {
    if (this.certificateBundles != null) {this.certificateBundles.clear();}
    if (certificateBundles != null) {for (CertificateBundleSpec item :certificateBundles){ this.addToCertificateBundles(item);}} return (A) this;
  }
  public Boolean hasCertificateBundles() {
    return certificateBundles != null && !certificateBundles.isEmpty();
  }
  public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> addNewCertificateBundle() {
    return new ClusterDeploymentSpecFluentImpl.CertificateBundlesNestedImpl();
  }
  public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> addNewCertificateBundleLike(CertificateBundleSpec item) {
    return new ClusterDeploymentSpecFluentImpl.CertificateBundlesNestedImpl(-1, item);
  }
  public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> setNewCertificateBundleLike(Integer index,CertificateBundleSpec item) {
    return new ClusterDeploymentSpecFluentImpl.CertificateBundlesNestedImpl(index, item);
  }
  public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> editCertificateBundle(Integer index) {
    if (certificateBundles.size() <= index) throw new RuntimeException("Can't edit certificateBundles. Index exceeds size.");
    return setNewCertificateBundleLike(index, buildCertificateBundle(index));
  }
  public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> editFirstCertificateBundle() {
    if (certificateBundles.size() == 0) throw new RuntimeException("Can't edit first certificateBundles. The list is empty.");
    return setNewCertificateBundleLike(0, buildCertificateBundle(0));
  }
  public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> editLastCertificateBundle() {
    int index = certificateBundles.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last certificateBundles. The list is empty.");
    return setNewCertificateBundleLike(index, buildCertificateBundle(index));
  }
  public ClusterDeploymentSpecFluent.CertificateBundlesNested<A> editMatchingCertificateBundle(Predicate<CertificateBundleSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<certificateBundles.size();i++) { 
    if (predicate.test(certificateBundles.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching certificateBundles. No match found.");
    return setNewCertificateBundleLike(index, buildCertificateBundle(index));
  }
  
  /**
   * This method has been deprecated, please use method buildClusterInstallRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterInstallLocalReference getClusterInstallRef() {
    return this.clusterInstallRef!=null ?this.clusterInstallRef.build():null;
  }
  public ClusterInstallLocalReference buildClusterInstallRef() {
    return this.clusterInstallRef!=null ?this.clusterInstallRef.build():null;
  }
  public A withClusterInstallRef(ClusterInstallLocalReference clusterInstallRef) {
    _visitables.get("clusterInstallRef").remove(this.clusterInstallRef);
    if (clusterInstallRef!=null){ this.clusterInstallRef= new ClusterInstallLocalReferenceBuilder(clusterInstallRef); _visitables.get("clusterInstallRef").add(this.clusterInstallRef);} else { this.clusterInstallRef = null; _visitables.get("clusterInstallRef").remove(this.clusterInstallRef); } return (A) this;
  }
  public Boolean hasClusterInstallRef() {
    return this.clusterInstallRef != null;
  }
  public A withNewClusterInstallRef(String group,String kind,String name,String version) {
    return (A)withClusterInstallRef(new ClusterInstallLocalReference(group, kind, name, version));
  }
  public ClusterDeploymentSpecFluent.ClusterInstallRefNested<A> withNewClusterInstallRef() {
    return new ClusterDeploymentSpecFluentImpl.ClusterInstallRefNestedImpl();
  }
  public ClusterDeploymentSpecFluent.ClusterInstallRefNested<A> withNewClusterInstallRefLike(ClusterInstallLocalReference item) {
    return new ClusterDeploymentSpecFluentImpl.ClusterInstallRefNestedImpl(item);
  }
  public ClusterDeploymentSpecFluent.ClusterInstallRefNested<A> editClusterInstallRef() {
    return withNewClusterInstallRefLike(getClusterInstallRef());
  }
  public ClusterDeploymentSpecFluent.ClusterInstallRefNested<A> editOrNewClusterInstallRef() {
    return withNewClusterInstallRefLike(getClusterInstallRef() != null ? getClusterInstallRef(): new ClusterInstallLocalReferenceBuilder().build());
  }
  public ClusterDeploymentSpecFluent.ClusterInstallRefNested<A> editOrNewClusterInstallRefLike(ClusterInstallLocalReference item) {
    return withNewClusterInstallRefLike(getClusterInstallRef() != null ? getClusterInstallRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildClusterMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterMetadata getClusterMetadata() {
    return this.clusterMetadata!=null ?this.clusterMetadata.build():null;
  }
  public ClusterMetadata buildClusterMetadata() {
    return this.clusterMetadata!=null ?this.clusterMetadata.build():null;
  }
  public A withClusterMetadata(ClusterMetadata clusterMetadata) {
    _visitables.get("clusterMetadata").remove(this.clusterMetadata);
    if (clusterMetadata!=null){ this.clusterMetadata= new ClusterMetadataBuilder(clusterMetadata); _visitables.get("clusterMetadata").add(this.clusterMetadata);} else { this.clusterMetadata = null; _visitables.get("clusterMetadata").remove(this.clusterMetadata); } return (A) this;
  }
  public Boolean hasClusterMetadata() {
    return this.clusterMetadata != null;
  }
  public ClusterDeploymentSpecFluent.ClusterMetadataNested<A> withNewClusterMetadata() {
    return new ClusterDeploymentSpecFluentImpl.ClusterMetadataNestedImpl();
  }
  public ClusterDeploymentSpecFluent.ClusterMetadataNested<A> withNewClusterMetadataLike(ClusterMetadata item) {
    return new ClusterDeploymentSpecFluentImpl.ClusterMetadataNestedImpl(item);
  }
  public ClusterDeploymentSpecFluent.ClusterMetadataNested<A> editClusterMetadata() {
    return withNewClusterMetadataLike(getClusterMetadata());
  }
  public ClusterDeploymentSpecFluent.ClusterMetadataNested<A> editOrNewClusterMetadata() {
    return withNewClusterMetadataLike(getClusterMetadata() != null ? getClusterMetadata(): new ClusterMetadataBuilder().build());
  }
  public ClusterDeploymentSpecFluent.ClusterMetadataNested<A> editOrNewClusterMetadataLike(ClusterMetadata item) {
    return withNewClusterMetadataLike(getClusterMetadata() != null ? getClusterMetadata(): item);
  }
  public String getClusterName() {
    return this.clusterName;
  }
  public A withClusterName(String clusterName) {
    this.clusterName=clusterName; return (A) this;
  }
  public Boolean hasClusterName() {
    return this.clusterName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterPoolRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClusterPoolReference getClusterPoolRef() {
    return this.clusterPoolRef!=null ?this.clusterPoolRef.build():null;
  }
  public ClusterPoolReference buildClusterPoolRef() {
    return this.clusterPoolRef!=null ?this.clusterPoolRef.build():null;
  }
  public A withClusterPoolRef(ClusterPoolReference clusterPoolRef) {
    _visitables.get("clusterPoolRef").remove(this.clusterPoolRef);
    if (clusterPoolRef!=null){ this.clusterPoolRef= new ClusterPoolReferenceBuilder(clusterPoolRef); _visitables.get("clusterPoolRef").add(this.clusterPoolRef);} else { this.clusterPoolRef = null; _visitables.get("clusterPoolRef").remove(this.clusterPoolRef); } return (A) this;
  }
  public Boolean hasClusterPoolRef() {
    return this.clusterPoolRef != null;
  }
  public A withNewClusterPoolRef(String claimName,String claimedTimestamp,String namespace,String poolName) {
    return (A)withClusterPoolRef(new ClusterPoolReference(claimName, claimedTimestamp, namespace, poolName));
  }
  public ClusterDeploymentSpecFluent.ClusterPoolRefNested<A> withNewClusterPoolRef() {
    return new ClusterDeploymentSpecFluentImpl.ClusterPoolRefNestedImpl();
  }
  public ClusterDeploymentSpecFluent.ClusterPoolRefNested<A> withNewClusterPoolRefLike(ClusterPoolReference item) {
    return new ClusterDeploymentSpecFluentImpl.ClusterPoolRefNestedImpl(item);
  }
  public ClusterDeploymentSpecFluent.ClusterPoolRefNested<A> editClusterPoolRef() {
    return withNewClusterPoolRefLike(getClusterPoolRef());
  }
  public ClusterDeploymentSpecFluent.ClusterPoolRefNested<A> editOrNewClusterPoolRef() {
    return withNewClusterPoolRefLike(getClusterPoolRef() != null ? getClusterPoolRef(): new ClusterPoolReferenceBuilder().build());
  }
  public ClusterDeploymentSpecFluent.ClusterPoolRefNested<A> editOrNewClusterPoolRefLike(ClusterPoolReference item) {
    return withNewClusterPoolRefLike(getClusterPoolRef() != null ? getClusterPoolRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildControlPlaneConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public ControlPlaneConfigSpec getControlPlaneConfig() {
    return this.controlPlaneConfig!=null ?this.controlPlaneConfig.build():null;
  }
  public ControlPlaneConfigSpec buildControlPlaneConfig() {
    return this.controlPlaneConfig!=null ?this.controlPlaneConfig.build():null;
  }
  public A withControlPlaneConfig(ControlPlaneConfigSpec controlPlaneConfig) {
    _visitables.get("controlPlaneConfig").remove(this.controlPlaneConfig);
    if (controlPlaneConfig!=null){ this.controlPlaneConfig= new ControlPlaneConfigSpecBuilder(controlPlaneConfig); _visitables.get("controlPlaneConfig").add(this.controlPlaneConfig);} else { this.controlPlaneConfig = null; _visitables.get("controlPlaneConfig").remove(this.controlPlaneConfig); } return (A) this;
  }
  public Boolean hasControlPlaneConfig() {
    return this.controlPlaneConfig != null;
  }
  public ClusterDeploymentSpecFluent.ControlPlaneConfigNested<A> withNewControlPlaneConfig() {
    return new ClusterDeploymentSpecFluentImpl.ControlPlaneConfigNestedImpl();
  }
  public ClusterDeploymentSpecFluent.ControlPlaneConfigNested<A> withNewControlPlaneConfigLike(ControlPlaneConfigSpec item) {
    return new ClusterDeploymentSpecFluentImpl.ControlPlaneConfigNestedImpl(item);
  }
  public ClusterDeploymentSpecFluent.ControlPlaneConfigNested<A> editControlPlaneConfig() {
    return withNewControlPlaneConfigLike(getControlPlaneConfig());
  }
  public ClusterDeploymentSpecFluent.ControlPlaneConfigNested<A> editOrNewControlPlaneConfig() {
    return withNewControlPlaneConfigLike(getControlPlaneConfig() != null ? getControlPlaneConfig(): new ControlPlaneConfigSpecBuilder().build());
  }
  public ClusterDeploymentSpecFluent.ControlPlaneConfigNested<A> editOrNewControlPlaneConfigLike(ControlPlaneConfigSpec item) {
    return withNewControlPlaneConfigLike(getControlPlaneConfig() != null ? getControlPlaneConfig(): item);
  }
  public Duration getHibernateAfter() {
    return this.hibernateAfter;
  }
  public A withHibernateAfter(Duration hibernateAfter) {
    this.hibernateAfter=hibernateAfter; return (A) this;
  }
  public Boolean hasHibernateAfter() {
    return this.hibernateAfter != null;
  }
  public A addToIngress(Integer index,ClusterIngress item) {
    if (this.ingress == null) {this.ingress = new ArrayList<ClusterIngressBuilder>();}
    ClusterIngressBuilder builder = new ClusterIngressBuilder(item);_visitables.get("ingress").add(index >= 0 ? index : _visitables.get("ingress").size(), builder);this.ingress.add(index >= 0 ? index : ingress.size(), builder); return (A)this;
  }
  public A setToIngress(Integer index,ClusterIngress item) {
    if (this.ingress == null) {this.ingress = new ArrayList<ClusterIngressBuilder>();}
    ClusterIngressBuilder builder = new ClusterIngressBuilder(item);
    if (index < 0 || index >= _visitables.get("ingress").size()) { _visitables.get("ingress").add(builder); } else { _visitables.get("ingress").set(index, builder);}
    if (index < 0 || index >= ingress.size()) { ingress.add(builder); } else { ingress.set(index, builder);}
     return (A)this;
  }
  public A addToIngress(io.fabric8.openshift.api.model.hive.v1.ClusterIngress... items) {
    if (this.ingress == null) {this.ingress = new ArrayList<ClusterIngressBuilder>();}
    for (ClusterIngress item : items) {ClusterIngressBuilder builder = new ClusterIngressBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  public A addAllToIngress(Collection<ClusterIngress> items) {
    if (this.ingress == null) {this.ingress = new ArrayList<ClusterIngressBuilder>();}
    for (ClusterIngress item : items) {ClusterIngressBuilder builder = new ClusterIngressBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  public A removeFromIngress(io.fabric8.openshift.api.model.hive.v1.ClusterIngress... items) {
    for (ClusterIngress item : items) {ClusterIngressBuilder builder = new ClusterIngressBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
  }
  public A removeAllFromIngress(Collection<ClusterIngress> items) {
    for (ClusterIngress item : items) {ClusterIngressBuilder builder = new ClusterIngressBuilder(item);_visitables.get("ingress").remove(builder);if (this.ingress != null) {this.ingress.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromIngress(Predicate<ClusterIngressBuilder> predicate) {
    if (ingress == null) return (A) this;
    final Iterator<ClusterIngressBuilder> each = ingress.iterator();
    final List visitables = _visitables.get("ingress");
    while (each.hasNext()) {
      ClusterIngressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildIngress instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterIngress> getIngress() {
    return ingress != null ? build(ingress) : null;
  }
  public List<ClusterIngress> buildIngress() {
    return ingress != null ? build(ingress) : null;
  }
  public ClusterIngress buildIngress(Integer index) {
    return this.ingress.get(index).build();
  }
  public ClusterIngress buildFirstIngress() {
    return this.ingress.get(0).build();
  }
  public ClusterIngress buildLastIngress() {
    return this.ingress.get(ingress.size() - 1).build();
  }
  public ClusterIngress buildMatchingIngress(Predicate<ClusterIngressBuilder> predicate) {
    for (ClusterIngressBuilder item: ingress) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingIngress(Predicate<ClusterIngressBuilder> predicate) {
    for (ClusterIngressBuilder item: ingress) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIngress(List<ClusterIngress> ingress) {
    if (this.ingress != null) { _visitables.get("ingress").removeAll(this.ingress);}
    if (ingress != null) {this.ingress = new ArrayList(); for (ClusterIngress item : ingress){this.addToIngress(item);}} else { this.ingress = null;} return (A) this;
  }
  public A withIngress(io.fabric8.openshift.api.model.hive.v1.ClusterIngress... ingress) {
    if (this.ingress != null) {this.ingress.clear();}
    if (ingress != null) {for (ClusterIngress item :ingress){ this.addToIngress(item);}} return (A) this;
  }
  public Boolean hasIngress() {
    return ingress != null && !ingress.isEmpty();
  }
  public ClusterDeploymentSpecFluent.IngressNested<A> addNewIngress() {
    return new ClusterDeploymentSpecFluentImpl.IngressNestedImpl();
  }
  public ClusterDeploymentSpecFluent.IngressNested<A> addNewIngressLike(ClusterIngress item) {
    return new ClusterDeploymentSpecFluentImpl.IngressNestedImpl(-1, item);
  }
  public ClusterDeploymentSpecFluent.IngressNested<A> setNewIngressLike(Integer index,ClusterIngress item) {
    return new ClusterDeploymentSpecFluentImpl.IngressNestedImpl(index, item);
  }
  public ClusterDeploymentSpecFluent.IngressNested<A> editIngress(Integer index) {
    if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public ClusterDeploymentSpecFluent.IngressNested<A> editFirstIngress() {
    if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
    return setNewIngressLike(0, buildIngress(0));
  }
  public ClusterDeploymentSpecFluent.IngressNested<A> editLastIngress() {
    int index = ingress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public ClusterDeploymentSpecFluent.IngressNested<A> editMatchingIngress(Predicate<ClusterIngressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ingress.size();i++) { 
    if (predicate.test(ingress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
    return setNewIngressLike(index, buildIngress(index));
  }
  public Integer getInstallAttemptsLimit() {
    return this.installAttemptsLimit;
  }
  public A withInstallAttemptsLimit(Integer installAttemptsLimit) {
    this.installAttemptsLimit=installAttemptsLimit; return (A) this;
  }
  public Boolean hasInstallAttemptsLimit() {
    return this.installAttemptsLimit != null;
  }
  public Boolean getInstalled() {
    return this.installed;
  }
  public A withInstalled(Boolean installed) {
    this.installed=installed; return (A) this;
  }
  public Boolean hasInstalled() {
    return this.installed != null;
  }
  public Boolean getManageDNS() {
    return this.manageDNS;
  }
  public A withManageDNS(Boolean manageDNS) {
    this.manageDNS=manageDNS; return (A) this;
  }
  public Boolean hasManageDNS() {
    return this.manageDNS != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public Platform getPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public Platform buildPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public A withPlatform(Platform platform) {
    _visitables.get("platform").remove(this.platform);
    if (platform!=null){ this.platform= new PlatformBuilder(platform); _visitables.get("platform").add(this.platform);} else { this.platform = null; _visitables.get("platform").remove(this.platform); } return (A) this;
  }
  public Boolean hasPlatform() {
    return this.platform != null;
  }
  public ClusterDeploymentSpecFluent.PlatformNested<A> withNewPlatform() {
    return new ClusterDeploymentSpecFluentImpl.PlatformNestedImpl();
  }
  public ClusterDeploymentSpecFluent.PlatformNested<A> withNewPlatformLike(Platform item) {
    return new ClusterDeploymentSpecFluentImpl.PlatformNestedImpl(item);
  }
  public ClusterDeploymentSpecFluent.PlatformNested<A> editPlatform() {
    return withNewPlatformLike(getPlatform());
  }
  public ClusterDeploymentSpecFluent.PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(getPlatform() != null ? getPlatform(): new PlatformBuilder().build());
  }
  public ClusterDeploymentSpecFluent.PlatformNested<A> editOrNewPlatformLike(Platform item) {
    return withNewPlatformLike(getPlatform() != null ? getPlatform(): item);
  }
  public String getPowerState() {
    return this.powerState;
  }
  public A withPowerState(String powerState) {
    this.powerState=powerState; return (A) this;
  }
  public Boolean hasPowerState() {
    return this.powerState != null;
  }
  public Boolean getPreserveOnDelete() {
    return this.preserveOnDelete;
  }
  public A withPreserveOnDelete(Boolean preserveOnDelete) {
    this.preserveOnDelete=preserveOnDelete; return (A) this;
  }
  public Boolean hasPreserveOnDelete() {
    return this.preserveOnDelete != null;
  }
  
  /**
   * This method has been deprecated, please use method buildProvisioning instead.
   * @return The buildable object.
   */
  @Deprecated
  public Provisioning getProvisioning() {
    return this.provisioning!=null ?this.provisioning.build():null;
  }
  public Provisioning buildProvisioning() {
    return this.provisioning!=null ?this.provisioning.build():null;
  }
  public A withProvisioning(Provisioning provisioning) {
    _visitables.get("provisioning").remove(this.provisioning);
    if (provisioning!=null){ this.provisioning= new ProvisioningBuilder(provisioning); _visitables.get("provisioning").add(this.provisioning);} else { this.provisioning = null; _visitables.get("provisioning").remove(this.provisioning); } return (A) this;
  }
  public Boolean hasProvisioning() {
    return this.provisioning != null;
  }
  public ClusterDeploymentSpecFluent.ProvisioningNested<A> withNewProvisioning() {
    return new ClusterDeploymentSpecFluentImpl.ProvisioningNestedImpl();
  }
  public ClusterDeploymentSpecFluent.ProvisioningNested<A> withNewProvisioningLike(Provisioning item) {
    return new ClusterDeploymentSpecFluentImpl.ProvisioningNestedImpl(item);
  }
  public ClusterDeploymentSpecFluent.ProvisioningNested<A> editProvisioning() {
    return withNewProvisioningLike(getProvisioning());
  }
  public ClusterDeploymentSpecFluent.ProvisioningNested<A> editOrNewProvisioning() {
    return withNewProvisioningLike(getProvisioning() != null ? getProvisioning(): new ProvisioningBuilder().build());
  }
  public ClusterDeploymentSpecFluent.ProvisioningNested<A> editOrNewProvisioningLike(Provisioning item) {
    return withNewProvisioningLike(getProvisioning() != null ? getProvisioning(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPullSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getPullSecretRef() {
    return this.pullSecretRef!=null ?this.pullSecretRef.build():null;
  }
  public LocalObjectReference buildPullSecretRef() {
    return this.pullSecretRef!=null ?this.pullSecretRef.build():null;
  }
  public A withPullSecretRef(LocalObjectReference pullSecretRef) {
    _visitables.get("pullSecretRef").remove(this.pullSecretRef);
    if (pullSecretRef!=null){ this.pullSecretRef= new LocalObjectReferenceBuilder(pullSecretRef); _visitables.get("pullSecretRef").add(this.pullSecretRef);} else { this.pullSecretRef = null; _visitables.get("pullSecretRef").remove(this.pullSecretRef); } return (A) this;
  }
  public Boolean hasPullSecretRef() {
    return this.pullSecretRef != null;
  }
  public A withNewPullSecretRef(String name) {
    return (A)withPullSecretRef(new LocalObjectReference(name));
  }
  public ClusterDeploymentSpecFluent.PullSecretRefNested<A> withNewPullSecretRef() {
    return new ClusterDeploymentSpecFluentImpl.PullSecretRefNestedImpl();
  }
  public ClusterDeploymentSpecFluent.PullSecretRefNested<A> withNewPullSecretRefLike(LocalObjectReference item) {
    return new ClusterDeploymentSpecFluentImpl.PullSecretRefNestedImpl(item);
  }
  public ClusterDeploymentSpecFluent.PullSecretRefNested<A> editPullSecretRef() {
    return withNewPullSecretRefLike(getPullSecretRef());
  }
  public ClusterDeploymentSpecFluent.PullSecretRefNested<A> editOrNewPullSecretRef() {
    return withNewPullSecretRefLike(getPullSecretRef() != null ? getPullSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public ClusterDeploymentSpecFluent.PullSecretRefNested<A> editOrNewPullSecretRefLike(LocalObjectReference item) {
    return withNewPullSecretRefLike(getPullSecretRef() != null ? getPullSecretRef(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterDeploymentSpecFluentImpl that = (ClusterDeploymentSpecFluentImpl) o;
    if (baseDomain != null ? !baseDomain.equals(that.baseDomain) :that.baseDomain != null) return false;
    if (boundServiceAccountSigningKeySecretRef != null ? !boundServiceAccountSigningKeySecretRef.equals(that.boundServiceAccountSigningKeySecretRef) :that.boundServiceAccountSigningKeySecretRef != null) return false;
    if (certificateBundles != null ? !certificateBundles.equals(that.certificateBundles) :that.certificateBundles != null) return false;
    if (clusterInstallRef != null ? !clusterInstallRef.equals(that.clusterInstallRef) :that.clusterInstallRef != null) return false;
    if (clusterMetadata != null ? !clusterMetadata.equals(that.clusterMetadata) :that.clusterMetadata != null) return false;
    if (clusterName != null ? !clusterName.equals(that.clusterName) :that.clusterName != null) return false;
    if (clusterPoolRef != null ? !clusterPoolRef.equals(that.clusterPoolRef) :that.clusterPoolRef != null) return false;
    if (controlPlaneConfig != null ? !controlPlaneConfig.equals(that.controlPlaneConfig) :that.controlPlaneConfig != null) return false;
    if (hibernateAfter != null ? !hibernateAfter.equals(that.hibernateAfter) :that.hibernateAfter != null) return false;
    if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
    if (installAttemptsLimit != null ? !installAttemptsLimit.equals(that.installAttemptsLimit) :that.installAttemptsLimit != null) return false;
    if (installed != null ? !installed.equals(that.installed) :that.installed != null) return false;
    if (manageDNS != null ? !manageDNS.equals(that.manageDNS) :that.manageDNS != null) return false;
    if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
    if (powerState != null ? !powerState.equals(that.powerState) :that.powerState != null) return false;
    if (preserveOnDelete != null ? !preserveOnDelete.equals(that.preserveOnDelete) :that.preserveOnDelete != null) return false;
    if (provisioning != null ? !provisioning.equals(that.provisioning) :that.provisioning != null) return false;
    if (pullSecretRef != null ? !pullSecretRef.equals(that.pullSecretRef) :that.pullSecretRef != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(baseDomain,  boundServiceAccountSigningKeySecretRef,  certificateBundles,  clusterInstallRef,  clusterMetadata,  clusterName,  clusterPoolRef,  controlPlaneConfig,  hibernateAfter,  ingress,  installAttemptsLimit,  installed,  manageDNS,  platform,  powerState,  preserveOnDelete,  provisioning,  pullSecretRef,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (baseDomain != null) { sb.append("baseDomain:"); sb.append(baseDomain + ","); }
    if (boundServiceAccountSigningKeySecretRef != null) { sb.append("boundServiceAccountSigningKeySecretRef:"); sb.append(boundServiceAccountSigningKeySecretRef + ","); }
    if (certificateBundles != null && !certificateBundles.isEmpty()) { sb.append("certificateBundles:"); sb.append(certificateBundles + ","); }
    if (clusterInstallRef != null) { sb.append("clusterInstallRef:"); sb.append(clusterInstallRef + ","); }
    if (clusterMetadata != null) { sb.append("clusterMetadata:"); sb.append(clusterMetadata + ","); }
    if (clusterName != null) { sb.append("clusterName:"); sb.append(clusterName + ","); }
    if (clusterPoolRef != null) { sb.append("clusterPoolRef:"); sb.append(clusterPoolRef + ","); }
    if (controlPlaneConfig != null) { sb.append("controlPlaneConfig:"); sb.append(controlPlaneConfig + ","); }
    if (hibernateAfter != null) { sb.append("hibernateAfter:"); sb.append(hibernateAfter + ","); }
    if (ingress != null && !ingress.isEmpty()) { sb.append("ingress:"); sb.append(ingress + ","); }
    if (installAttemptsLimit != null) { sb.append("installAttemptsLimit:"); sb.append(installAttemptsLimit + ","); }
    if (installed != null) { sb.append("installed:"); sb.append(installed + ","); }
    if (manageDNS != null) { sb.append("manageDNS:"); sb.append(manageDNS + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (powerState != null) { sb.append("powerState:"); sb.append(powerState + ","); }
    if (preserveOnDelete != null) { sb.append("preserveOnDelete:"); sb.append(preserveOnDelete + ","); }
    if (provisioning != null) { sb.append("provisioning:"); sb.append(provisioning + ","); }
    if (pullSecretRef != null) { sb.append("pullSecretRef:"); sb.append(pullSecretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withInstalled() {
    return withInstalled(true);
  }
  public A withManageDNS() {
    return withManageDNS(true);
  }
  public A withPreserveOnDelete() {
    return withPreserveOnDelete(true);
  }
  class BoundServiceAccountSigningKeySecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<N>> implements ClusterDeploymentSpecFluent.BoundServiceAccountSigningKeySecretRefNested<N>,Nested<N>{
    BoundServiceAccountSigningKeySecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    BoundServiceAccountSigningKeySecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterDeploymentSpecFluentImpl.this.withBoundServiceAccountSigningKeySecretRef(builder.build());
    }
    public N endBoundServiceAccountSigningKeySecretRef() {
      return and();
    }
    
  }
  class CertificateBundlesNestedImpl<N> extends CertificateBundleSpecFluentImpl<ClusterDeploymentSpecFluent.CertificateBundlesNested<N>> implements ClusterDeploymentSpecFluent.CertificateBundlesNested<N>,Nested<N>{
    CertificateBundlesNestedImpl(Integer index,CertificateBundleSpec item) {
      this.index = index;
      this.builder = new CertificateBundleSpecBuilder(this, item);
    }
    CertificateBundlesNestedImpl() {
      this.index = -1;
      this.builder = new CertificateBundleSpecBuilder(this);
    }
    CertificateBundleSpecBuilder builder;
    Integer index;
    public N and() {
      return (N) ClusterDeploymentSpecFluentImpl.this.setToCertificateBundles(index,builder.build());
    }
    public N endCertificateBundle() {
      return and();
    }
    
  }
  class ClusterInstallRefNestedImpl<N> extends ClusterInstallLocalReferenceFluentImpl<ClusterDeploymentSpecFluent.ClusterInstallRefNested<N>> implements ClusterDeploymentSpecFluent.ClusterInstallRefNested<N>,Nested<N>{
    ClusterInstallRefNestedImpl(ClusterInstallLocalReference item) {
      this.builder = new ClusterInstallLocalReferenceBuilder(this, item);
    }
    ClusterInstallRefNestedImpl() {
      this.builder = new ClusterInstallLocalReferenceBuilder(this);
    }
    ClusterInstallLocalReferenceBuilder builder;
    public N and() {
      return (N) ClusterDeploymentSpecFluentImpl.this.withClusterInstallRef(builder.build());
    }
    public N endClusterInstallRef() {
      return and();
    }
    
  }
  class ClusterMetadataNestedImpl<N> extends ClusterMetadataFluentImpl<ClusterDeploymentSpecFluent.ClusterMetadataNested<N>> implements ClusterDeploymentSpecFluent.ClusterMetadataNested<N>,Nested<N>{
    ClusterMetadataNestedImpl(ClusterMetadata item) {
      this.builder = new ClusterMetadataBuilder(this, item);
    }
    ClusterMetadataNestedImpl() {
      this.builder = new ClusterMetadataBuilder(this);
    }
    ClusterMetadataBuilder builder;
    public N and() {
      return (N) ClusterDeploymentSpecFluentImpl.this.withClusterMetadata(builder.build());
    }
    public N endClusterMetadata() {
      return and();
    }
    
  }
  class ClusterPoolRefNestedImpl<N> extends ClusterPoolReferenceFluentImpl<ClusterDeploymentSpecFluent.ClusterPoolRefNested<N>> implements ClusterDeploymentSpecFluent.ClusterPoolRefNested<N>,Nested<N>{
    ClusterPoolRefNestedImpl(ClusterPoolReference item) {
      this.builder = new ClusterPoolReferenceBuilder(this, item);
    }
    ClusterPoolRefNestedImpl() {
      this.builder = new ClusterPoolReferenceBuilder(this);
    }
    ClusterPoolReferenceBuilder builder;
    public N and() {
      return (N) ClusterDeploymentSpecFluentImpl.this.withClusterPoolRef(builder.build());
    }
    public N endClusterPoolRef() {
      return and();
    }
    
  }
  class ControlPlaneConfigNestedImpl<N> extends ControlPlaneConfigSpecFluentImpl<ClusterDeploymentSpecFluent.ControlPlaneConfigNested<N>> implements ClusterDeploymentSpecFluent.ControlPlaneConfigNested<N>,Nested<N>{
    ControlPlaneConfigNestedImpl(ControlPlaneConfigSpec item) {
      this.builder = new ControlPlaneConfigSpecBuilder(this, item);
    }
    ControlPlaneConfigNestedImpl() {
      this.builder = new ControlPlaneConfigSpecBuilder(this);
    }
    ControlPlaneConfigSpecBuilder builder;
    public N and() {
      return (N) ClusterDeploymentSpecFluentImpl.this.withControlPlaneConfig(builder.build());
    }
    public N endControlPlaneConfig() {
      return and();
    }
    
  }
  class IngressNestedImpl<N> extends ClusterIngressFluentImpl<ClusterDeploymentSpecFluent.IngressNested<N>> implements ClusterDeploymentSpecFluent.IngressNested<N>,Nested<N>{
    IngressNestedImpl(Integer index,ClusterIngress item) {
      this.index = index;
      this.builder = new ClusterIngressBuilder(this, item);
    }
    IngressNestedImpl() {
      this.index = -1;
      this.builder = new ClusterIngressBuilder(this);
    }
    ClusterIngressBuilder builder;
    Integer index;
    public N and() {
      return (N) ClusterDeploymentSpecFluentImpl.this.setToIngress(index,builder.build());
    }
    public N endIngress() {
      return and();
    }
    
  }
  class PlatformNestedImpl<N> extends PlatformFluentImpl<ClusterDeploymentSpecFluent.PlatformNested<N>> implements ClusterDeploymentSpecFluent.PlatformNested<N>,Nested<N>{
    PlatformNestedImpl(Platform item) {
      this.builder = new PlatformBuilder(this, item);
    }
    PlatformNestedImpl() {
      this.builder = new PlatformBuilder(this);
    }
    PlatformBuilder builder;
    public N and() {
      return (N) ClusterDeploymentSpecFluentImpl.this.withPlatform(builder.build());
    }
    public N endPlatform() {
      return and();
    }
    
  }
  class ProvisioningNestedImpl<N> extends ProvisioningFluentImpl<ClusterDeploymentSpecFluent.ProvisioningNested<N>> implements ClusterDeploymentSpecFluent.ProvisioningNested<N>,Nested<N>{
    ProvisioningNestedImpl(Provisioning item) {
      this.builder = new ProvisioningBuilder(this, item);
    }
    ProvisioningNestedImpl() {
      this.builder = new ProvisioningBuilder(this);
    }
    ProvisioningBuilder builder;
    public N and() {
      return (N) ClusterDeploymentSpecFluentImpl.this.withProvisioning(builder.build());
    }
    public N endProvisioning() {
      return and();
    }
    
  }
  class PullSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ClusterDeploymentSpecFluent.PullSecretRefNested<N>> implements ClusterDeploymentSpecFluent.PullSecretRefNested<N>,Nested<N>{
    PullSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    PullSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterDeploymentSpecFluentImpl.this.withPullSecretRef(builder.build());
    }
    public N endPullSecretRef() {
      return and();
    }
    
  }
  
}