package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterDeprovisionSpecBuilder extends ClusterDeprovisionSpecFluentImpl<ClusterDeprovisionSpecBuilder> implements VisitableBuilder<ClusterDeprovisionSpec,ClusterDeprovisionSpecBuilder>{
  public ClusterDeprovisionSpecBuilder() {
    this(false);
  }
  public ClusterDeprovisionSpecBuilder(Boolean validationEnabled) {
    this(new ClusterDeprovisionSpec(), validationEnabled);
  }
  public ClusterDeprovisionSpecBuilder(ClusterDeprovisionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDeprovisionSpecBuilder(ClusterDeprovisionSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterDeprovisionSpec(), validationEnabled);
  }
  public ClusterDeprovisionSpecBuilder(ClusterDeprovisionSpecFluent<?> fluent,ClusterDeprovisionSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterDeprovisionSpecBuilder(ClusterDeprovisionSpecFluent<?> fluent,ClusterDeprovisionSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterID(instance.getClusterID()); 
    fluent.withInfraID(instance.getInfraID()); 
    fluent.withPlatform(instance.getPlatform()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterDeprovisionSpecBuilder(ClusterDeprovisionSpec instance) {
    this(instance,false);
  }
  public ClusterDeprovisionSpecBuilder(ClusterDeprovisionSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterID(instance.getClusterID()); 
    this.withInfraID(instance.getInfraID()); 
    this.withPlatform(instance.getPlatform()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterDeprovisionSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterDeprovisionSpec build() {
    ClusterDeprovisionSpec buildable = new ClusterDeprovisionSpec(fluent.getClusterID(),fluent.getInfraID(),fluent.getPlatform());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}