package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterOperatorStateFluentImpl<A extends ClusterOperatorStateFluent<A>> extends BaseFluent<A> implements ClusterOperatorStateFluent<A>{
  public ClusterOperatorStateFluentImpl() {
  }
  public ClusterOperatorStateFluentImpl(ClusterOperatorState instance) {
    this.withConditions(instance.getConditions()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<ClusterOperatorStatusCondition> conditions = new ArrayList<ClusterOperatorStatusCondition>();
  private String name;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusCondition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(Integer index,ClusterOperatorStatusCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusCondition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusCondition>();}
    for (ClusterOperatorStatusCondition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<ClusterOperatorStatusCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ClusterOperatorStatusCondition>();}
    for (ClusterOperatorStatusCondition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... items) {
    for (ClusterOperatorStatusCondition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<ClusterOperatorStatusCondition> items) {
    for (ClusterOperatorStatusCondition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public List<ClusterOperatorStatusCondition> getConditions() {
    return this.conditions;
  }
  public ClusterOperatorStatusCondition getCondition(Integer index) {
    return this.conditions.get(index);
  }
  public ClusterOperatorStatusCondition getFirstCondition() {
    return this.conditions.get(0);
  }
  public ClusterOperatorStatusCondition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public ClusterOperatorStatusCondition getMatchingCondition(Predicate<ClusterOperatorStatusCondition> predicate) {
    for (ClusterOperatorStatusCondition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<ClusterOperatorStatusCondition> predicate) {
    for (ClusterOperatorStatusCondition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<ClusterOperatorStatusCondition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (ClusterOperatorStatusCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.config.v1.ClusterOperatorStatusCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (ClusterOperatorStatusCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new ClusterOperatorStatusCondition(lastTransitionTime, message, reason, status, type));
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterOperatorStateFluentImpl that = (ClusterOperatorStateFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  name,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}