package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ControllerConfigBuilder extends ControllerConfigFluentImpl<ControllerConfigBuilder> implements VisitableBuilder<ControllerConfig,ControllerConfigBuilder>{
  public ControllerConfigBuilder() {
    this(false);
  }
  public ControllerConfigBuilder(Boolean validationEnabled) {
    this(new ControllerConfig(), validationEnabled);
  }
  public ControllerConfigBuilder(ControllerConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ControllerConfigBuilder(ControllerConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ControllerConfig(), validationEnabled);
  }
  public ControllerConfigBuilder(ControllerConfigFluent<?> fluent,ControllerConfig instance) {
    this(fluent, instance, false);
  }
  public ControllerConfigBuilder(ControllerConfigFluent<?> fluent,ControllerConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClientBurst(instance.getClientBurst()); 
    fluent.withClientQPS(instance.getClientQPS()); 
    fluent.withConcurrentReconciles(instance.getConcurrentReconciles()); 
    fluent.withQueueBurst(instance.getQueueBurst()); 
    fluent.withQueueQPS(instance.getQueueQPS()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ControllerConfigBuilder(ControllerConfig instance) {
    this(instance,false);
  }
  public ControllerConfigBuilder(ControllerConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withClientBurst(instance.getClientBurst()); 
    this.withClientQPS(instance.getClientQPS()); 
    this.withConcurrentReconciles(instance.getConcurrentReconciles()); 
    this.withQueueBurst(instance.getQueueBurst()); 
    this.withQueueQPS(instance.getQueueQPS()); 
    this.withReplicas(instance.getReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ControllerConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ControllerConfig build() {
    ControllerConfig buildable = new ControllerConfig(fluent.getClientBurst(),fluent.getClientQPS(),fluent.getConcurrentReconciles(),fluent.getQueueBurst(),fluent.getQueueQPS(),fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}