package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FailedProvisionConfigBuilder extends FailedProvisionConfigFluentImpl<FailedProvisionConfigBuilder> implements VisitableBuilder<FailedProvisionConfig,FailedProvisionConfigBuilder>{
  public FailedProvisionConfigBuilder() {
    this(false);
  }
  public FailedProvisionConfigBuilder(Boolean validationEnabled) {
    this(new FailedProvisionConfig(), validationEnabled);
  }
  public FailedProvisionConfigBuilder(FailedProvisionConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public FailedProvisionConfigBuilder(FailedProvisionConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FailedProvisionConfig(), validationEnabled);
  }
  public FailedProvisionConfigBuilder(FailedProvisionConfigFluent<?> fluent,FailedProvisionConfig instance) {
    this(fluent, instance, false);
  }
  public FailedProvisionConfigBuilder(FailedProvisionConfigFluent<?> fluent,FailedProvisionConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAws(instance.getAws()); 
    fluent.withRetryReasons(instance.getRetryReasons()); 
    fluent.withSkipGatherLogs(instance.getSkipGatherLogs()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FailedProvisionConfigBuilder(FailedProvisionConfig instance) {
    this(instance,false);
  }
  public FailedProvisionConfigBuilder(FailedProvisionConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAws(instance.getAws()); 
    this.withRetryReasons(instance.getRetryReasons()); 
    this.withSkipGatherLogs(instance.getSkipGatherLogs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  FailedProvisionConfigFluent<?> fluent;
  Boolean validationEnabled;
  public FailedProvisionConfig build() {
    FailedProvisionConfig buildable = new FailedProvisionConfig(fluent.getAws(),fluent.getRetryReasons(),fluent.getSkipGatherLogs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}