package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HiveConfigBuilder extends HiveConfigFluentImpl<HiveConfigBuilder> implements VisitableBuilder<HiveConfig,HiveConfigBuilder>{
  public HiveConfigBuilder() {
    this(false);
  }
  public HiveConfigBuilder(Boolean validationEnabled) {
    this(new HiveConfig(), validationEnabled);
  }
  public HiveConfigBuilder(HiveConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public HiveConfigBuilder(HiveConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HiveConfig(), validationEnabled);
  }
  public HiveConfigBuilder(HiveConfigFluent<?> fluent,HiveConfig instance) {
    this(fluent, instance, false);
  }
  public HiveConfigBuilder(HiveConfigFluent<?> fluent,HiveConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HiveConfigBuilder(HiveConfig instance) {
    this(instance,false);
  }
  public HiveConfigBuilder(HiveConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HiveConfigFluent<?> fluent;
  Boolean validationEnabled;
  public HiveConfig build() {
    HiveConfig buildable = new HiveConfig(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}