package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HiveConfigStatusBuilder extends HiveConfigStatusFluentImpl<HiveConfigStatusBuilder> implements VisitableBuilder<HiveConfigStatus,HiveConfigStatusBuilder>{
  public HiveConfigStatusBuilder() {
    this(false);
  }
  public HiveConfigStatusBuilder(Boolean validationEnabled) {
    this(new HiveConfigStatus(), validationEnabled);
  }
  public HiveConfigStatusBuilder(HiveConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public HiveConfigStatusBuilder(HiveConfigStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HiveConfigStatus(), validationEnabled);
  }
  public HiveConfigStatusBuilder(HiveConfigStatusFluent<?> fluent,HiveConfigStatus instance) {
    this(fluent, instance, false);
  }
  public HiveConfigStatusBuilder(HiveConfigStatusFluent<?> fluent,HiveConfigStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAggregatorClientCAHash(instance.getAggregatorClientCAHash()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withConfigApplied(instance.getConfigApplied()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HiveConfigStatusBuilder(HiveConfigStatus instance) {
    this(instance,false);
  }
  public HiveConfigStatusBuilder(HiveConfigStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAggregatorClientCAHash(instance.getAggregatorClientCAHash()); 
    this.withConditions(instance.getConditions()); 
    this.withConfigApplied(instance.getConfigApplied()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HiveConfigStatusFluent<?> fluent;
  Boolean validationEnabled;
  public HiveConfigStatus build() {
    HiveConfigStatus buildable = new HiveConfigStatus(fluent.getAggregatorClientCAHash(),fluent.getConditions(),fluent.getConfigApplied(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}