package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolSpecBuilder extends MachinePoolSpecFluentImpl<MachinePoolSpecBuilder> implements VisitableBuilder<MachinePoolSpec,MachinePoolSpecBuilder>{
  public MachinePoolSpecBuilder() {
    this(false);
  }
  public MachinePoolSpecBuilder(Boolean validationEnabled) {
    this(new MachinePoolSpec(), validationEnabled);
  }
  public MachinePoolSpecBuilder(MachinePoolSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolSpecBuilder(MachinePoolSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolSpec(), validationEnabled);
  }
  public MachinePoolSpecBuilder(MachinePoolSpecFluent<?> fluent,MachinePoolSpec instance) {
    this(fluent, instance, false);
  }
  public MachinePoolSpecBuilder(MachinePoolSpecFluent<?> fluent,MachinePoolSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAutoscaling(instance.getAutoscaling()); 
    fluent.withClusterDeploymentRef(instance.getClusterDeploymentRef()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withName(instance.getName()); 
    fluent.withPlatform(instance.getPlatform()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withTaints(instance.getTaints()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolSpecBuilder(MachinePoolSpec instance) {
    this(instance,false);
  }
  public MachinePoolSpecBuilder(MachinePoolSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAutoscaling(instance.getAutoscaling()); 
    this.withClusterDeploymentRef(instance.getClusterDeploymentRef()); 
    this.withLabels(instance.getLabels()); 
    this.withName(instance.getName()); 
    this.withPlatform(instance.getPlatform()); 
    this.withReplicas(instance.getReplicas()); 
    this.withTaints(instance.getTaints()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MachinePoolSpecFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolSpec build() {
    MachinePoolSpec buildable = new MachinePoolSpec(fluent.getAutoscaling(),fluent.getClusterDeploymentRef(),fluent.getLabels(),fluent.getName(),fluent.getPlatform(),fluent.getReplicas(),fluent.getTaints());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}