package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MachinePoolPlatformBuilder extends MachinePoolPlatformFluentImpl<MachinePoolPlatformBuilder> implements VisitableBuilder<MachinePoolPlatform,MachinePoolPlatformBuilder>{
  public MachinePoolPlatformBuilder() {
    this(false);
  }
  public MachinePoolPlatformBuilder(Boolean validationEnabled) {
    this(new MachinePoolPlatform(), validationEnabled);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent) {
    this(fluent, false);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MachinePoolPlatform(), validationEnabled);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,MachinePoolPlatform instance) {
    this(fluent, instance, false);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatformFluent<?> fluent,MachinePoolPlatform instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRootVolume(instance.getRootVolume()); 
    fluent.withSpotMarketOptions(instance.getSpotMarketOptions()); 
    fluent.withSubnets(instance.getSubnets()); 
    fluent.withType(instance.getType()); 
    fluent.withZones(instance.getZones()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatform instance) {
    this(instance,false);
  }
  public MachinePoolPlatformBuilder(MachinePoolPlatform instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRootVolume(instance.getRootVolume()); 
    this.withSpotMarketOptions(instance.getSpotMarketOptions()); 
    this.withSubnets(instance.getSubnets()); 
    this.withType(instance.getType()); 
    this.withZones(instance.getZones()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  MachinePoolPlatformFluent<?> fluent;
  Boolean validationEnabled;
  public MachinePoolPlatform build() {
    MachinePoolPlatform buildable = new MachinePoolPlatform(fluent.getRootVolume(),fluent.getSpotMarketOptions(),fluent.getSubnets(),fluent.getType(),fluent.getZones());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}